# This file was auto-generated by Fern from our API Definition.

import enum
import typing

T_Result = typing.TypeVar("T_Result")


class ObservationStatus(str, enum.Enum):
    """
    The status of the result value.
    """

    REGISTERED = "registered"
    PRELIMINARY = "preliminary"
    FINAL = "final"
    AMENDED = "amended"
    CORRECTED = "corrected"
    CANCELLED = "cancelled"
    ENTERED_IN_ERROR = "entered-in-error"
    UNKNOWN = "unknown"

    def visit(
        self,
        registered: typing.Callable[[], T_Result],
        preliminary: typing.Callable[[], T_Result],
        final: typing.Callable[[], T_Result],
        amended: typing.Callable[[], T_Result],
        corrected: typing.Callable[[], T_Result],
        cancelled: typing.Callable[[], T_Result],
        entered_in_error: typing.Callable[[], T_Result],
        unknown: typing.Callable[[], T_Result],
    ) -> T_Result:
        if self is ObservationStatus.REGISTERED:
            return registered()
        if self is ObservationStatus.PRELIMINARY:
            return preliminary()
        if self is ObservationStatus.FINAL:
            return final()
        if self is ObservationStatus.AMENDED:
            return amended()
        if self is ObservationStatus.CORRECTED:
            return corrected()
        if self is ObservationStatus.CANCELLED:
            return cancelled()
        if self is ObservationStatus.ENTERED_IN_ERROR:
            return entered_in_error()
        if self is ObservationStatus.UNKNOWN:
            return unknown()
