# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import datetime as dt
import typing

from ...core.datetime_utils import serialize_datetime
from .canonical import Canonical
from .code import Code
from .extension import Extension
from .operation_definition_binding import OperationDefinitionBinding
from .operation_definition_parameter_search_type import OperationDefinitionParameterSearchType
from .operation_definition_parameter_use import OperationDefinitionParameterUse
from .operation_definition_referenced_from import OperationDefinitionReferencedFrom

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class OperationDefinitionParameter(pydantic.BaseModel):
    """
    A formal computable definition of an operation (on the RESTful interface) or a named query (using the search interaction).
    """

    id: typing.Optional[str] = pydantic.Field(
        default=None,
        description="Unique id for the element within a resource (for internal references). This may be any string value that does not contain spaces.",
    )
    extension: typing.Optional[typing.List[Extension]] = pydantic.Field(
        default=None,
        description="May be used to represent additional information that is not part of the basic definition of the element. To make the use of extensions safe and manageable, there is a strict set of governance applied to the definition and use of extensions. Though any implementer can define an extension, there is a set of requirements that SHALL be met as part of the definition of the extension.",
    )
    modifier_extension: typing.Optional[typing.List[Extension]] = pydantic.Field(
        alias="modifierExtension",
        default=None,
        description="May be used to represent additional information that is not part of the basic definition of the element and that modifies the understanding of the element in which it is contained and/or the understanding of the containing element's descendants. Usually modifier elements provide negation or qualification. To make the use of extensions safe and manageable, there is a strict set of governance applied to the definition and use of extensions. Though any implementer can define an extension, there is a set of requirements that SHALL be met as part of the definition of the extension. Applications processing a resource are required to check for modifier extensions. Modifier extensions SHALL NOT change the meaning of any elements on Resource or DomainResource (including cannot change the meaning of modifierExtension itself).",
    )
    name: typing.Optional[Code] = pydantic.Field(
        default=None, description="The name of used to identify the parameter."
    )
    use: typing.Optional[OperationDefinitionParameterUse] = pydantic.Field(
        default=None, description="Whether this is an input or an output parameter."
    )
    min: typing.Optional[int] = pydantic.Field(
        default=None, description="The minimum number of times this parameter SHALL appear in the request or response."
    )
    max: typing.Optional[str] = pydantic.Field(
        default=None,
        description="The maximum number of times this element is permitted to appear in the request or response.",
    )
    documentation: typing.Optional[str] = pydantic.Field(
        default=None, description="Describes the meaning or use of this parameter."
    )
    type: typing.Optional[Code] = pydantic.Field(default=None, description="The type for this parameter.")
    target_profile: typing.Optional[typing.List[Canonical]] = pydantic.Field(
        alias="targetProfile",
        default=None,
        description='Used when the type is "Reference" or "canonical", and identifies a profile structure or implementation Guide that applies to the target of the reference this parameter refers to. If any profiles are specified, then the content must conform to at least one of them. The URL can be a local reference - to a contained StructureDefinition, or a reference to another StructureDefinition or Implementation Guide by a canonical URL. When an implementation guide is specified, the target resource SHALL conform to at least one profile defined in the implementation guide.',
    )
    search_type: typing.Optional[OperationDefinitionParameterSearchType] = pydantic.Field(
        alias="searchType",
        default=None,
        description="How the parameter is understood as a search parameter. This is only used if the parameter type is 'string'.",
    )
    binding: typing.Optional[OperationDefinitionBinding] = pydantic.Field(
        default=None, description="Binds to a value set if this parameter is coded (code, Coding, CodeableConcept)."
    )
    referenced_from: typing.Optional[typing.List[OperationDefinitionReferencedFrom]] = pydantic.Field(
        alias="referencedFrom",
        default=None,
        description="Identifies other resource parameters within the operation invocation that are expected to resolve to this resource.",
    )
    part: typing.Optional[typing.List[OperationDefinitionParameter]] = pydantic.Field(
        default=None, description="The parts of a nested Parameter."
    )

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        allow_population_by_field_name = True
        json_encoders = {dt.datetime: serialize_datetime}


OperationDefinitionParameter.update_forward_refs()
