# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ...core.datetime_utils import serialize_datetime
from .address import Address
from .base_resource import BaseResource
from .codeable_concept import CodeableConcept
from .contact_point import ContactPoint
from .identifier import Identifier
from .organization_contact import OrganizationContact
from .reference import Reference

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class Organization(BaseResource):
    """
    A formally or informally recognized grouping of people or organizations formed for the purpose of achieving some form of collective action. Includes companies, institutions, corporations, departments, community groups, healthcare practice groups, payer/insurer, etc.
    """

    resource_type: typing.Literal["Organization"] = pydantic.Field(alias="resourceType")
    identifier: typing.Optional[typing.List[Identifier]] = pydantic.Field(
        default=None,
        description="Identifier for the organization that is used to identify the organization across multiple disparate systems.",
    )
    active: typing.Optional[bool] = pydantic.Field(
        default=None, description="Whether the organization's record is still in active use."
    )
    type: typing.Optional[typing.List[CodeableConcept]] = pydantic.Field(
        default=None, description="The kind(s) of organization that this is."
    )
    name: typing.Optional[str] = pydantic.Field(default=None, description="A name associated with the organization.")
    alias: typing.Optional[typing.List[str]] = pydantic.Field(
        default=None,
        description="A list of alternate names that the organization is known as, or was known as in the past.",
    )
    telecom: typing.Optional[typing.List[ContactPoint]] = pydantic.Field(
        default=None, description="A contact detail for the organization."
    )
    address: typing.Optional[typing.List[Address]] = pydantic.Field(
        default=None, description="An address for the organization."
    )
    part_of: typing.Optional[Reference] = pydantic.Field(
        alias="partOf", default=None, description="The organization of which this organization forms a part."
    )
    contact: typing.Optional[typing.List[OrganizationContact]] = pydantic.Field(
        default=None, description="Contact for the organization for a certain purpose."
    )
    endpoint: typing.Optional[typing.List[Reference]] = pydantic.Field(
        default=None, description="Technical endpoints providing access to services operated for the organization."
    )

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        allow_population_by_field_name = True
        json_encoders = {dt.datetime: serialize_datetime}
