# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ...core.datetime_utils import serialize_datetime
from .base_resource import BaseResource
from .codeable_concept import CodeableConcept
from .contact_point import ContactPoint
from .identifier import Identifier
from .period import Period
from .reference import Reference

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class OrganizationAffiliation(BaseResource):
    """
    Defines an affiliation/assotiation/relationship between 2 distinct oganizations, that is not a part-of relationship/sub-division relationship.
    """

    resource_type: typing.Literal["OrganizationAffiliation"] = pydantic.Field(alias="resourceType")
    identifier: typing.Optional[typing.List[Identifier]] = pydantic.Field(
        default=None, description="Business identifiers that are specific to this role."
    )
    active: typing.Optional[bool] = pydantic.Field(
        default=None, description="Whether this organization affiliation record is in active use."
    )
    period: typing.Optional[Period] = pydantic.Field(
        default=None,
        description="The period during which the participatingOrganization is affiliated with the primary organization.",
    )
    organization: typing.Optional[Reference] = pydantic.Field(
        default=None, description="Organization where the role is available (primary organization/has members)."
    )
    participating_organization: typing.Optional[Reference] = pydantic.Field(
        alias="participatingOrganization",
        default=None,
        description="The Participating Organization provides/performs the role(s) defined by the code to the Primary Organization (e.g. providing services or is a member of).",
    )
    network: typing.Optional[typing.List[Reference]] = pydantic.Field(
        default=None,
        description="Health insurance provider network in which the participatingOrganization provides the role's services (if defined) at the indicated locations (if defined).",
    )
    code: typing.Optional[typing.List[CodeableConcept]] = pydantic.Field(
        default=None, description="Definition of the role the participatingOrganization plays in the association."
    )
    specialty: typing.Optional[typing.List[CodeableConcept]] = pydantic.Field(
        default=None, description="Specific specialty of the participatingOrganization in the context of the role."
    )
    location: typing.Optional[typing.List[Reference]] = pydantic.Field(
        default=None, description="The location(s) at which the role occurs."
    )
    healthcare_service: typing.Optional[typing.List[Reference]] = pydantic.Field(
        alias="healthcareService", default=None, description="Healthcare services provided through the role."
    )
    telecom: typing.Optional[typing.List[ContactPoint]] = pydantic.Field(
        default=None, description="Contact details at the participatingOrganization relevant to this Affiliation."
    )
    endpoint: typing.Optional[typing.List[Reference]] = pydantic.Field(
        default=None, description="Technical endpoints providing access to services operated for this role."
    )

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        allow_population_by_field_name = True
        json_encoders = {dt.datetime: serialize_datetime}
