# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ...core.datetime_utils import serialize_datetime
from .code import Code
from .id import Id
from .meta import Meta
from .password_change_request_type import PasswordChangeRequestType
from .reference import Reference
from .uri import Uri

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class PasswordChangeRequest(pydantic.BaseModel):
    """
    Password change request for the 'forgot password' flow.
    """

    resource_type: typing.Literal["PasswordChangeRequest"] = pydantic.Field(alias="resourceType")
    id: typing.Optional[Id] = pydantic.Field(
        default=None,
        description="The logical id of the resource, as used in the URL for the resource. Once assigned, this value never changes.",
    )
    meta: typing.Optional[Meta] = pydantic.Field(
        default=None,
        description="The metadata about the resource. This is content that is maintained by the infrastructure. Changes to the content might not always be associated with version changes to the resource.",
    )
    implicit_rules: typing.Optional[Uri] = pydantic.Field(
        alias="implicitRules",
        default=None,
        description="A reference to a set of rules that were followed when the resource was constructed, and which must be understood when processing the content. Often, this is a reference to an implementation guide that defines the special rules along with other profiles etc.",
    )
    language: typing.Optional[Code] = pydantic.Field(
        default=None, description="The base language in which the resource is written."
    )
    type: typing.Optional[PasswordChangeRequestType] = pydantic.Field(
        default=None, description="The type of password change request (invite or reset)."
    )
    user: Reference = pydantic.Field(description="The user requesting the password change.")
    secret: str = pydantic.Field(description="Secret string used to verify the identity of the user.")
    used: typing.Optional[bool] = pydantic.Field(
        default=None, description="Whether this request has been used, and is therefore no longer valid."
    )
    redirect_uri: typing.Optional[Uri] = pydantic.Field(
        alias="redirectUri",
        default=None,
        description="Redirect URI used when redirecting a client back to the client application.",
    )

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        allow_population_by_field_name = True
        json_encoders = {dt.datetime: serialize_datetime}
