# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ...core.datetime_utils import serialize_datetime
from .address import Address
from .codeable_concept import CodeableConcept
from .contact_point import ContactPoint
from .extension import Extension
from .human_name import HumanName
from .patient_contact_gender import PatientContactGender
from .period import Period
from .reference import Reference

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class PatientContact(pydantic.BaseModel):
    """
    Demographics and other administrative information about an individual or animal receiving care or other health-related services.
    """

    id: typing.Optional[str] = pydantic.Field(
        default=None,
        description="Unique id for the element within a resource (for internal references). This may be any string value that does not contain spaces.",
    )
    extension: typing.Optional[typing.List[Extension]] = pydantic.Field(
        default=None,
        description="May be used to represent additional information that is not part of the basic definition of the element. To make the use of extensions safe and manageable, there is a strict set of governance applied to the definition and use of extensions. Though any implementer can define an extension, there is a set of requirements that SHALL be met as part of the definition of the extension.",
    )
    modifier_extension: typing.Optional[typing.List[Extension]] = pydantic.Field(
        alias="modifierExtension",
        default=None,
        description="May be used to represent additional information that is not part of the basic definition of the element and that modifies the understanding of the element in which it is contained and/or the understanding of the containing element's descendants. Usually modifier elements provide negation or qualification. To make the use of extensions safe and manageable, there is a strict set of governance applied to the definition and use of extensions. Though any implementer can define an extension, there is a set of requirements that SHALL be met as part of the definition of the extension. Applications processing a resource are required to check for modifier extensions. Modifier extensions SHALL NOT change the meaning of any elements on Resource or DomainResource (including cannot change the meaning of modifierExtension itself).",
    )
    relationship: typing.Optional[typing.List[CodeableConcept]] = pydantic.Field(
        default=None, description="The nature of the relationship between the patient and the contact person."
    )
    name: typing.Optional[HumanName] = pydantic.Field(
        default=None, description="A name associated with the contact person."
    )
    telecom: typing.Optional[typing.List[ContactPoint]] = pydantic.Field(
        default=None, description="A contact detail for the person, e.g. a telephone number or an email address."
    )
    address: typing.Optional[Address] = pydantic.Field(default=None, description="Address for the contact person.")
    gender: typing.Optional[PatientContactGender] = pydantic.Field(
        default=None,
        description="Administrative Gender - the gender that the contact person is considered to have for administration and record keeping purposes.",
    )
    organization: typing.Optional[Reference] = pydantic.Field(
        default=None,
        description="Organization on behalf of which the contact is acting or for which the contact is working.",
    )
    period: typing.Optional[Period] = pydantic.Field(
        default=None,
        description="The period during which this contact person or organization is valid to be contacted relating to this patient.",
    )

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        allow_population_by_field_name = True
        json_encoders = {dt.datetime: serialize_datetime}
