# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ...core.datetime_utils import serialize_datetime
from .base_resource import BaseResource
from .code import Code
from .codeable_concept import CodeableConcept
from .date_time import DateTime
from .identifier import Identifier
from .money import Money
from .payment_reconciliation_detail import PaymentReconciliationDetail
from .payment_reconciliation_outcome import PaymentReconciliationOutcome
from .payment_reconciliation_process_note import PaymentReconciliationProcessNote
from .period import Period
from .reference import Reference

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class PaymentReconciliation(BaseResource):
    """
    This resource provides the details including amount of a payment and allocates the payment items being paid.
    """

    resource_type: typing.Literal["PaymentReconciliation"] = pydantic.Field(alias="resourceType")
    identifier: typing.Optional[typing.List[Identifier]] = pydantic.Field(
        default=None, description="A unique identifier assigned to this payment reconciliation."
    )
    status: typing.Optional[Code] = pydantic.Field(default=None, description="The status of the resource instance.")
    period: typing.Optional[Period] = pydantic.Field(
        default=None,
        description="The period of time for which payments have been gathered into this bulk payment for settlement.",
    )
    created: typing.Optional[DateTime] = pydantic.Field(
        default=None, description="The date when the resource was created."
    )
    payment_issuer: typing.Optional[Reference] = pydantic.Field(
        alias="paymentIssuer", default=None, description="The party who generated the payment."
    )
    request: typing.Optional[Reference] = pydantic.Field(
        default=None, description="Original request resource reference."
    )
    requestor: typing.Optional[Reference] = pydantic.Field(
        default=None, description="The practitioner who is responsible for the services rendered to the patient."
    )
    outcome: typing.Optional[PaymentReconciliationOutcome] = pydantic.Field(
        default=None, description="The outcome of a request for a reconciliation."
    )
    disposition: typing.Optional[str] = pydantic.Field(
        default=None, description="A human readable description of the status of the request for the reconciliation."
    )
    payment_date: typing.Optional[dt.date] = pydantic.Field(
        alias="paymentDate", default=None, description="The date of payment as indicated on the financial instrument."
    )
    payment_amount: Money = pydantic.Field(
        alias="paymentAmount", description="Total payment amount as indicated on the financial instrument."
    )
    payment_identifier: typing.Optional[Identifier] = pydantic.Field(
        alias="paymentIdentifier", default=None, description="Issuer's unique identifier for the payment instrument."
    )
    detail: typing.Optional[typing.List[PaymentReconciliationDetail]] = pydantic.Field(
        default=None, description="Distribution of the payment amount for a previously acknowledged payable."
    )
    form_code: typing.Optional[CodeableConcept] = pydantic.Field(
        alias="formCode", default=None, description="A code for the form to be used for printing the content."
    )
    process_note: typing.Optional[typing.List[PaymentReconciliationProcessNote]] = pydantic.Field(
        alias="processNote",
        default=None,
        description="A note that describes or explains the processing in a human readable form.",
    )

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        allow_population_by_field_name = True
        json_encoders = {dt.datetime: serialize_datetime}
