# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ...core.datetime_utils import serialize_datetime
from .codeable_concept import CodeableConcept
from .extension import Extension
from .identifier import Identifier
from .money import Money
from .reference import Reference

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class PaymentReconciliationDetail(pydantic.BaseModel):
    """
    This resource provides the details including amount of a payment and allocates the payment items being paid.
    """

    id: typing.Optional[str] = pydantic.Field(
        default=None,
        description="Unique id for the element within a resource (for internal references). This may be any string value that does not contain spaces.",
    )
    extension: typing.Optional[typing.List[Extension]] = pydantic.Field(
        default=None,
        description="May be used to represent additional information that is not part of the basic definition of the element. To make the use of extensions safe and manageable, there is a strict set of governance applied to the definition and use of extensions. Though any implementer can define an extension, there is a set of requirements that SHALL be met as part of the definition of the extension.",
    )
    modifier_extension: typing.Optional[typing.List[Extension]] = pydantic.Field(
        alias="modifierExtension",
        default=None,
        description="May be used to represent additional information that is not part of the basic definition of the element and that modifies the understanding of the element in which it is contained and/or the understanding of the containing element's descendants. Usually modifier elements provide negation or qualification. To make the use of extensions safe and manageable, there is a strict set of governance applied to the definition and use of extensions. Though any implementer can define an extension, there is a set of requirements that SHALL be met as part of the definition of the extension. Applications processing a resource are required to check for modifier extensions. Modifier extensions SHALL NOT change the meaning of any elements on Resource or DomainResource (including cannot change the meaning of modifierExtension itself).",
    )
    identifier: typing.Optional[Identifier] = pydantic.Field(
        default=None, description="Unique identifier for the current payment item for the referenced payable."
    )
    predecessor: typing.Optional[Identifier] = pydantic.Field(
        default=None, description="Unique identifier for the prior payment item for the referenced payable."
    )
    type: CodeableConcept = pydantic.Field(description="Code to indicate the nature of the payment.")
    request: typing.Optional[Reference] = pydantic.Field(
        default=None, description="A resource, such as a Claim, the evaluation of which could lead to payment."
    )
    submitter: typing.Optional[Reference] = pydantic.Field(
        default=None, description="The party which submitted the claim or financial transaction."
    )
    response: typing.Optional[Reference] = pydantic.Field(
        default=None, description="A resource, such as a ClaimResponse, which contains a commitment to payment."
    )
    date: typing.Optional[dt.date] = pydantic.Field(
        default=None, description="The date from the response resource containing a commitment to pay."
    )
    responsible: typing.Optional[Reference] = pydantic.Field(
        default=None,
        description="A reference to the individual who is responsible for inquiries regarding the response and its payment.",
    )
    payee: typing.Optional[Reference] = pydantic.Field(
        default=None, description="The party which is receiving the payment."
    )
    amount: typing.Optional[Money] = pydantic.Field(
        default=None, description="The monetary amount allocated from the total payment to the payable."
    )

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        allow_population_by_field_name = True
        json_encoders = {dt.datetime: serialize_datetime}
