# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ...core.datetime_utils import serialize_datetime
from .address import Address
from .attachment import Attachment
from .base_resource import BaseResource
from .contact_point import ContactPoint
from .human_name import HumanName
from .identifier import Identifier
from .person_gender import PersonGender
from .person_link import PersonLink
from .reference import Reference

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class Person(BaseResource):
    """
    Demographics and administrative information about a person independent of a specific health-related context.
    """

    resource_type: typing.Literal["Person"] = pydantic.Field(alias="resourceType")
    identifier: typing.Optional[typing.List[Identifier]] = pydantic.Field(
        default=None, description="Identifier for a person within a particular scope."
    )
    name: typing.Optional[typing.List[HumanName]] = pydantic.Field(
        default=None, description="A name associated with the person."
    )
    telecom: typing.Optional[typing.List[ContactPoint]] = pydantic.Field(
        default=None, description="A contact detail for the person, e.g. a telephone number or an email address."
    )
    gender: typing.Optional[PersonGender] = pydantic.Field(default=None, description="Administrative Gender.")
    birth_date: typing.Optional[dt.date] = pydantic.Field(
        alias="birthDate", default=None, description="The birth date for the person."
    )
    address: typing.Optional[typing.List[Address]] = pydantic.Field(
        default=None, description="One or more addresses for the person."
    )
    photo: typing.Optional[Attachment] = pydantic.Field(
        default=None,
        description="An image that can be displayed as a thumbnail of the person to enhance the identification of the individual.",
    )
    managing_organization: typing.Optional[Reference] = pydantic.Field(
        alias="managingOrganization",
        default=None,
        description="The organization that is the custodian of the person record.",
    )
    active: typing.Optional[bool] = pydantic.Field(
        default=None, description="Whether this person's record is in active use."
    )
    link: typing.Optional[typing.List[PersonLink]] = pydantic.Field(
        default=None, description="Link to a resource that concerns the same actual person."
    )

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        allow_population_by_field_name = True
        json_encoders = {dt.datetime: serialize_datetime}
