# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import datetime as dt
import typing

from ...core.datetime_utils import serialize_datetime
from .age import Age
from .canonical import Canonical
from .code import Code
from .codeable_concept import CodeableConcept
from .data_requirement import DataRequirement
from .duration import Duration
from .extension import Extension
from .id import Id
from .period import Period
from .plan_definition_action_cardinality_behavior import PlanDefinitionActionCardinalityBehavior
from .plan_definition_action_grouping_behavior import PlanDefinitionActionGroupingBehavior
from .plan_definition_action_precheck_behavior import PlanDefinitionActionPrecheckBehavior
from .plan_definition_action_required_behavior import PlanDefinitionActionRequiredBehavior
from .plan_definition_action_selection_behavior import PlanDefinitionActionSelectionBehavior
from .plan_definition_condition import PlanDefinitionCondition
from .plan_definition_dynamic_value import PlanDefinitionDynamicValue
from .plan_definition_participant import PlanDefinitionParticipant
from .plan_definition_related_action import PlanDefinitionRelatedAction
from .range import Range
from .reference import Reference
from .related_artifact import RelatedArtifact
from .timing import Timing
from .trigger_definition import TriggerDefinition

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class PlanDefinitionAction(pydantic.BaseModel):
    """
    This resource allows for the definition of various types of plans as a sharable, consumable, and executable artifact. The resource is general enough to support the description of a broad range of clinical artifacts such as clinical decision support rules, order sets and protocols.
    """

    id: typing.Optional[str] = pydantic.Field(
        default=None,
        description="Unique id for the element within a resource (for internal references). This may be any string value that does not contain spaces.",
    )
    extension: typing.Optional[typing.List[Extension]] = pydantic.Field(
        default=None,
        description="May be used to represent additional information that is not part of the basic definition of the element. To make the use of extensions safe and manageable, there is a strict set of governance applied to the definition and use of extensions. Though any implementer can define an extension, there is a set of requirements that SHALL be met as part of the definition of the extension.",
    )
    modifier_extension: typing.Optional[typing.List[Extension]] = pydantic.Field(
        alias="modifierExtension",
        default=None,
        description="May be used to represent additional information that is not part of the basic definition of the element and that modifies the understanding of the element in which it is contained and/or the understanding of the containing element's descendants. Usually modifier elements provide negation or qualification. To make the use of extensions safe and manageable, there is a strict set of governance applied to the definition and use of extensions. Though any implementer can define an extension, there is a set of requirements that SHALL be met as part of the definition of the extension. Applications processing a resource are required to check for modifier extensions. Modifier extensions SHALL NOT change the meaning of any elements on Resource or DomainResource (including cannot change the meaning of modifierExtension itself).",
    )
    prefix: typing.Optional[str] = pydantic.Field(default=None, description="A user-visible prefix for the action.")
    title: typing.Optional[str] = pydantic.Field(
        default=None, description="The title of the action displayed to a user."
    )
    description: typing.Optional[str] = pydantic.Field(
        default=None, description="A brief description of the action used to provide a summary to display to the user."
    )
    text_equivalent: typing.Optional[str] = pydantic.Field(
        alias="textEquivalent",
        default=None,
        description="A text equivalent of the action to be performed. This provides a human-interpretable description of the action when the definition is consumed by a system that might not be capable of interpreting it dynamically.",
    )
    priority: typing.Optional[Code] = pydantic.Field(
        default=None, description="Indicates how quickly the action should be addressed with respect to other actions."
    )
    code: typing.Optional[typing.List[CodeableConcept]] = pydantic.Field(
        default=None,
        description="A code that provides meaning for the action or action group. For example, a section may have a LOINC code for the section of a documentation template.",
    )
    reason: typing.Optional[typing.List[CodeableConcept]] = pydantic.Field(
        default=None, description="A description of why this action is necessary or appropriate."
    )
    documentation: typing.Optional[typing.List[RelatedArtifact]] = pydantic.Field(
        default=None,
        description="Didactic or other informational resources associated with the action that can be provided to the CDS recipient. Information resources can include inline text commentary and links to web resources.",
    )
    goal_id: typing.Optional[typing.List[Id]] = pydantic.Field(
        alias="goalId",
        default=None,
        description="Identifies goals that this action supports. The reference must be to a goal element defined within this plan definition.",
    )
    subject_codeable_concept: typing.Optional[CodeableConcept] = pydantic.Field(
        alias="subjectCodeableConcept",
        default=None,
        description="A code or group definition that describes the intended subject of the action and its children, if any.",
    )
    subject_reference: typing.Optional[Reference] = pydantic.Field(
        alias="subjectReference",
        default=None,
        description="A code or group definition that describes the intended subject of the action and its children, if any.",
    )
    trigger: typing.Optional[typing.List[TriggerDefinition]] = pydantic.Field(
        default=None, description="A description of when the action should be triggered."
    )
    condition: typing.Optional[typing.List[PlanDefinitionCondition]] = pydantic.Field(
        default=None,
        description="An expression that describes applicability criteria or start/stop conditions for the action.",
    )
    input: typing.Optional[typing.List[DataRequirement]] = pydantic.Field(
        default=None, description="Defines input data requirements for the action."
    )
    output: typing.Optional[typing.List[DataRequirement]] = pydantic.Field(
        default=None, description="Defines the outputs of the action, if any."
    )
    related_action: typing.Optional[typing.List[PlanDefinitionRelatedAction]] = pydantic.Field(
        alias="relatedAction",
        default=None,
        description='A relationship to another action such as "before" or "30-60 minutes after start of".',
    )
    timing_date_time: typing.Optional[str] = pydantic.Field(
        alias="timingDateTime",
        default=None,
        description="An optional value describing when the action should be performed.",
    )
    timing_age: typing.Optional[Age] = pydantic.Field(
        alias="timingAge", default=None, description="An optional value describing when the action should be performed."
    )
    timing_period: typing.Optional[Period] = pydantic.Field(
        alias="timingPeriod",
        default=None,
        description="An optional value describing when the action should be performed.",
    )
    timing_duration: typing.Optional[Duration] = pydantic.Field(
        alias="timingDuration",
        default=None,
        description="An optional value describing when the action should be performed.",
    )
    timing_range: typing.Optional[Range] = pydantic.Field(
        alias="timingRange",
        default=None,
        description="An optional value describing when the action should be performed.",
    )
    timing_timing: typing.Optional[Timing] = pydantic.Field(
        alias="timingTiming",
        default=None,
        description="An optional value describing when the action should be performed.",
    )
    participant: typing.Optional[typing.List[PlanDefinitionParticipant]] = pydantic.Field(
        default=None, description="Indicates who should participate in performing the action described."
    )
    type: typing.Optional[CodeableConcept] = pydantic.Field(
        default=None, description="The type of action to perform (create, update, remove)."
    )
    grouping_behavior: typing.Optional[PlanDefinitionActionGroupingBehavior] = pydantic.Field(
        alias="groupingBehavior",
        default=None,
        description="Defines the grouping behavior for the action and its children.",
    )
    selection_behavior: typing.Optional[PlanDefinitionActionSelectionBehavior] = pydantic.Field(
        alias="selectionBehavior",
        default=None,
        description="Defines the selection behavior for the action and its children.",
    )
    required_behavior: typing.Optional[PlanDefinitionActionRequiredBehavior] = pydantic.Field(
        alias="requiredBehavior", default=None, description="Defines the required behavior for the action."
    )
    precheck_behavior: typing.Optional[PlanDefinitionActionPrecheckBehavior] = pydantic.Field(
        alias="precheckBehavior", default=None, description="Defines whether the action should usually be preselected."
    )
    cardinality_behavior: typing.Optional[PlanDefinitionActionCardinalityBehavior] = pydantic.Field(
        alias="cardinalityBehavior",
        default=None,
        description="Defines whether the action can be selected multiple times.",
    )
    definition_canonical: typing.Optional[str] = pydantic.Field(
        alias="definitionCanonical",
        default=None,
        description="A reference to an ActivityDefinition that describes the action to be taken in detail, or a PlanDefinition that describes a series of actions to be taken.",
    )
    definition_uri: typing.Optional[str] = pydantic.Field(
        alias="definitionUri",
        default=None,
        description="A reference to an ActivityDefinition that describes the action to be taken in detail, or a PlanDefinition that describes a series of actions to be taken.",
    )
    transform: typing.Optional[Canonical] = pydantic.Field(
        default=None,
        description="A reference to a StructureMap resource that defines a transform that can be executed to produce the intent resource using the ActivityDefinition instance as the input.",
    )
    dynamic_value: typing.Optional[typing.List[PlanDefinitionDynamicValue]] = pydantic.Field(
        alias="dynamicValue",
        default=None,
        description="Customizations that should be applied to the statically defined resource. For example, if the dosage of a medication must be computed based on the patient's weight, a customization would be used to specify an expression that calculated the weight, and the path on the resource that would contain the result.",
    )
    action: typing.Optional[typing.List[PlanDefinitionAction]] = pydantic.Field(
        default=None,
        description="Sub actions that are contained within the action. The behavior of this action determines the functionality of the sub-actions. For example, a selection behavior of at-most-one indicates that of the sub-actions, at most one may be chosen as part of realizing the action definition.",
    )

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        allow_population_by_field_name = True
        json_encoders = {dt.datetime: serialize_datetime}


PlanDefinitionAction.update_forward_refs()
