# This file was auto-generated by Fern from our API Definition.

import enum
import typing

T_Result = typing.TypeVar("T_Result")


class PlanDefinitionStatus(str, enum.Enum):
    """
    The status of this plan definition. Enables tracking the life-cycle of the content.
    """

    DRAFT = "draft"
    ACTIVE = "active"
    RETIRED = "retired"
    UNKNOWN = "unknown"

    def visit(
        self,
        draft: typing.Callable[[], T_Result],
        active: typing.Callable[[], T_Result],
        retired: typing.Callable[[], T_Result],
        unknown: typing.Callable[[], T_Result],
    ) -> T_Result:
        if self is PlanDefinitionStatus.DRAFT:
            return draft()
        if self is PlanDefinitionStatus.ACTIVE:
            return active()
        if self is PlanDefinitionStatus.RETIRED:
            return retired()
        if self is PlanDefinitionStatus.UNKNOWN:
            return unknown()
