# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ...core.datetime_utils import serialize_datetime
from .address import Address
from .attachment import Attachment
from .base_resource import BaseResource
from .codeable_concept import CodeableConcept
from .contact_point import ContactPoint
from .human_name import HumanName
from .identifier import Identifier
from .practitioner_gender import PractitionerGender
from .practitioner_qualification import PractitionerQualification

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class Practitioner(BaseResource):
    """
    A person who is directly or indirectly involved in the provisioning of healthcare.
    """

    resource_type: typing.Literal["Practitioner"] = pydantic.Field(alias="resourceType")
    identifier: typing.Optional[typing.List[Identifier]] = pydantic.Field(
        default=None, description="An identifier that applies to this person in this role."
    )
    active: typing.Optional[bool] = pydantic.Field(
        default=None, description="Whether this practitioner's record is in active use."
    )
    name: typing.Optional[typing.List[HumanName]] = pydantic.Field(
        default=None, description="The name(s) associated with the practitioner."
    )
    telecom: typing.Optional[typing.List[ContactPoint]] = pydantic.Field(
        default=None, description="A contact detail for the practitioner, e.g. a telephone number or an email address."
    )
    address: typing.Optional[typing.List[Address]] = pydantic.Field(
        default=None,
        description=(
            "Address(es) of the practitioner that are not role specific (typically home address).\n"
            "Work addresses are not typically entered in this property as they are usually role dependent.\n"
        ),
    )
    gender: typing.Optional[PractitionerGender] = pydantic.Field(
        default=None,
        description="Administrative Gender - the gender that the person is considered to have for administration and record keeping purposes.",
    )
    birth_date: typing.Optional[dt.date] = pydantic.Field(
        alias="birthDate", default=None, description="The date of birth for the practitioner."
    )
    photo: typing.Optional[typing.List[Attachment]] = pydantic.Field(default=None, description="Image of the person.")
    qualification: typing.Optional[typing.List[PractitionerQualification]] = pydantic.Field(
        default=None,
        description="The official certifications, training, and licenses that authorize or otherwise pertain to the provision of care by the practitioner. For example, a medical license issued by a medical board authorizing the practitioner to practice medicine within a certian locality.",
    )
    communication: typing.Optional[typing.List[CodeableConcept]] = pydantic.Field(
        default=None, description="A language the practitioner can use in patient communication."
    )

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        allow_population_by_field_name = True
        json_encoders = {dt.datetime: serialize_datetime}
