# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ...core.datetime_utils import serialize_datetime
from .base_resource import BaseResource
from .codeable_concept import CodeableConcept
from .contact_point import ContactPoint
from .identifier import Identifier
from .period import Period
from .practitioner_role_available_time import PractitionerRoleAvailableTime
from .practitioner_role_not_available import PractitionerRoleNotAvailable
from .reference import Reference

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class PractitionerRole(BaseResource):
    """
    A specific set of Roles/Locations/specialties/services that a practitioner may perform at an organization for a period of time.
    """

    resource_type: typing.Literal["PractitionerRole"] = pydantic.Field(alias="resourceType")
    identifier: typing.Optional[typing.List[Identifier]] = pydantic.Field(
        default=None, description="Business Identifiers that are specific to a role/location."
    )
    active: typing.Optional[bool] = pydantic.Field(
        default=None, description="Whether this practitioner role record is in active use."
    )
    period: typing.Optional[Period] = pydantic.Field(
        default=None,
        description="The period during which the person is authorized to act as a practitioner in these role(s) for the organization.",
    )
    practitioner: typing.Optional[Reference] = pydantic.Field(
        default=None, description="Practitioner that is able to provide the defined services for the organization."
    )
    organization: typing.Optional[Reference] = pydantic.Field(
        default=None, description="The organization where the Practitioner performs the roles associated."
    )
    code: typing.Optional[typing.List[CodeableConcept]] = pydantic.Field(
        default=None, description="Roles which this practitioner is authorized to perform for the organization."
    )
    specialty: typing.Optional[typing.List[CodeableConcept]] = pydantic.Field(
        default=None, description="Specific specialty of the practitioner."
    )
    location: typing.Optional[typing.List[Reference]] = pydantic.Field(
        default=None, description="The location(s) at which this practitioner provides care."
    )
    healthcare_service: typing.Optional[typing.List[Reference]] = pydantic.Field(
        alias="healthcareService",
        default=None,
        description="The list of healthcare services that this worker provides for this role's Organization/Location(s).",
    )
    telecom: typing.Optional[typing.List[ContactPoint]] = pydantic.Field(
        default=None, description="Contact details that are specific to the role/location/service."
    )
    available_time: typing.Optional[typing.List[PractitionerRoleAvailableTime]] = pydantic.Field(
        alias="availableTime",
        default=None,
        description="A collection of times the practitioner is available or performing this role at the location and/or healthcareservice.",
    )
    not_available: typing.Optional[typing.List[PractitionerRoleNotAvailable]] = pydantic.Field(
        alias="notAvailable",
        default=None,
        description="The practitioner is not available or performing this role during this period of time due to the provided reason.",
    )
    availability_exceptions: typing.Optional[str] = pydantic.Field(
        alias="availabilityExceptions",
        default=None,
        description="A description of site availability exceptions, e.g. public holiday availability. Succinctly describing all possible exceptions to normal site availability as details in the available Times and not available Times.",
    )
    endpoint: typing.Optional[typing.List[Reference]] = pydantic.Field(
        default=None,
        description="Technical endpoints providing access to services operated for the practitioner with this role.",
    )

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        allow_population_by_field_name = True
        json_encoders = {dt.datetime: serialize_datetime}
