# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ...core.datetime_utils import serialize_datetime
from .project_membership_access_parameter import ProjectMembershipAccessParameter
from .reference import Reference

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class ProjectMembershipAccess(pydantic.BaseModel):
    """
    Extended access configuration using parameterized access policies.
    """

    policy: Reference = pydantic.Field(
        description="The base access policy used as a template. Variables in the template access policy are replaced by the values in the parameter."
    )
    parameter: typing.Optional[typing.List[ProjectMembershipAccessParameter]] = pydantic.Field(
        default=None, description="User options that control the display of the application."
    )

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        json_encoders = {dt.datetime: serialize_datetime}
