# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ...core.datetime_utils import serialize_datetime
from .base_resource import BaseResource
from .codeable_concept import CodeableConcept
from .instant import Instant
from .period import Period
from .provenance_agent import ProvenanceAgent
from .provenance_entity import ProvenanceEntity
from .reference import Reference
from .signature import Signature
from .uri import Uri

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class Provenance(BaseResource):
    """
    Provenance of a resource is a record that describes entities and processes involved in producing and delivering or otherwise influencing that resource. Provenance provides a critical foundation for assessing authenticity, enabling trust, and allowing reproducibility. Provenance assertions are a form of contextual metadata and can themselves become important records with their own provenance. Provenance statement indicates clinical significance in terms of confidence in authenticity, reliability, and trustworthiness, integrity, and stage in lifecycle (e.g. Document Completion - has the artifact been legally authenticated), all of which may impact security, privacy, and trust policies.
    """

    resource_type: typing.Literal["Provenance"] = pydantic.Field(alias="resourceType")
    target: typing.List[Reference] = pydantic.Field(
        description="The Reference(s) that were generated or updated by the activity described in this resource. A provenance can point to more than one target if multiple resources were created/updated by the same activity."
    )
    occurred_period: typing.Optional[Period] = pydantic.Field(
        alias="occurredPeriod", default=None, description="The period during which the activity occurred."
    )
    occurred_date_time: typing.Optional[str] = pydantic.Field(
        alias="occurredDateTime", default=None, description="The period during which the activity occurred."
    )
    recorded: typing.Optional[Instant] = pydantic.Field(
        default=None, description="The instant of time at which the activity was recorded."
    )
    policy: typing.Optional[typing.List[Uri]] = pydantic.Field(
        default=None,
        description="Policy or plan the activity was defined by. Typically, a single activity may have multiple applicable policy documents, such as patient consent, guarantor funding, etc.",
    )
    location: typing.Optional[Reference] = pydantic.Field(
        default=None, description="Where the activity occurred, if relevant."
    )
    reason: typing.Optional[typing.List[CodeableConcept]] = pydantic.Field(
        default=None, description="The reason that the activity was taking place."
    )
    activity: typing.Optional[CodeableConcept] = pydantic.Field(
        default=None,
        description="An activity is something that occurs over a period of time and acts upon or with entities; it may include consuming, processing, transforming, modifying, relocating, using, or generating entities.",
    )
    agent: typing.List[ProvenanceAgent] = pydantic.Field(
        description="An actor taking a role in an activity for which it can be assigned some degree of responsibility for the activity taking place."
    )
    entity: typing.Optional[typing.List[ProvenanceEntity]] = pydantic.Field(
        default=None, description="An entity used in this activity."
    )
    signature: typing.Optional[typing.List[Signature]] = pydantic.Field(
        default=None,
        description="A digital signature on the target Reference(s). The signer should match a Provenance.agent. The purpose of the signature is indicated.",
    )

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        allow_population_by_field_name = True
        json_encoders = {dt.datetime: serialize_datetime}
