# This file was auto-generated by Fern from our API Definition.

import enum
import typing

T_Result = typing.TypeVar("T_Result")


class ProvenanceEntityRole(str, enum.Enum):
    """
    How the entity was used during the activity.
    """

    DERIVATION = "derivation"
    REVISION = "revision"
    QUOTATION = "quotation"
    SOURCE = "source"
    REMOVAL = "removal"

    def visit(
        self,
        derivation: typing.Callable[[], T_Result],
        revision: typing.Callable[[], T_Result],
        quotation: typing.Callable[[], T_Result],
        source: typing.Callable[[], T_Result],
        removal: typing.Callable[[], T_Result],
    ) -> T_Result:
        if self is ProvenanceEntityRole.DERIVATION:
            return derivation()
        if self is ProvenanceEntityRole.REVISION:
            return revision()
        if self is ProvenanceEntityRole.QUOTATION:
            return quotation()
        if self is ProvenanceEntityRole.SOURCE:
            return source()
        if self is ProvenanceEntityRole.REMOVAL:
            return removal()
