# This file was auto-generated by Fern from our API Definition.

import enum
import typing

T_Result = typing.TypeVar("T_Result")


class QuantityComparator(str, enum.Enum):
    """
    How the value should be understood and represented - whether the actual value is greater or less than the stated value due to measurement issues; e.g. if the comparator is "<" , then the real value is < stated value.
    """

    LESS_THAN = "<"
    LESS_THAN_OR_EQUAL_TO = "<="
    GREATER_THAN_OR_EQUAL_TO = ">="
    GREATER_THAN = ">"

    def visit(
        self,
        less_than: typing.Callable[[], T_Result],
        less_than_or_equal_to: typing.Callable[[], T_Result],
        greater_than_or_equal_to: typing.Callable[[], T_Result],
        greater_than: typing.Callable[[], T_Result],
    ) -> T_Result:
        if self is QuantityComparator.LESS_THAN:
            return less_than()
        if self is QuantityComparator.LESS_THAN_OR_EQUAL_TO:
            return less_than_or_equal_to()
        if self is QuantityComparator.GREATER_THAN_OR_EQUAL_TO:
            return greater_than_or_equal_to()
        if self is QuantityComparator.GREATER_THAN:
            return greater_than()
