# This file was auto-generated by Fern from our API Definition.

import enum
import typing

T_Result = typing.TypeVar("T_Result")


class QuestionnaireItemType(str, enum.Enum):
    """
    The type of questionnaire item this is - whether text for display, a grouping of other items or a particular type of data to be captured (string, integer, coded choice, etc.).
    """

    GROUP = "group"
    DISPLAY = "display"
    BOOLEAN = "boolean"
    DECIMAL = "decimal"
    INTEGER = "integer"
    DATE = "date"
    DATE_TIME = "dateTime"
    TIME = "time"
    STRING = "string"
    TEXT = "text"
    URL = "url"
    CHOICE = "choice"
    OPEN_CHOICE = "open-choice"
    ATTACHMENT = "attachment"
    REFERENCE = "reference"
    QUANTITY = "quantity"

    def visit(
        self,
        group: typing.Callable[[], T_Result],
        display: typing.Callable[[], T_Result],
        boolean: typing.Callable[[], T_Result],
        decimal: typing.Callable[[], T_Result],
        integer: typing.Callable[[], T_Result],
        date: typing.Callable[[], T_Result],
        date_time: typing.Callable[[], T_Result],
        time: typing.Callable[[], T_Result],
        string: typing.Callable[[], T_Result],
        text: typing.Callable[[], T_Result],
        url: typing.Callable[[], T_Result],
        choice: typing.Callable[[], T_Result],
        open_choice: typing.Callable[[], T_Result],
        attachment: typing.Callable[[], T_Result],
        reference: typing.Callable[[], T_Result],
        quantity: typing.Callable[[], T_Result],
    ) -> T_Result:
        if self is QuestionnaireItemType.GROUP:
            return group()
        if self is QuestionnaireItemType.DISPLAY:
            return display()
        if self is QuestionnaireItemType.BOOLEAN:
            return boolean()
        if self is QuestionnaireItemType.DECIMAL:
            return decimal()
        if self is QuestionnaireItemType.INTEGER:
            return integer()
        if self is QuestionnaireItemType.DATE:
            return date()
        if self is QuestionnaireItemType.DATE_TIME:
            return date_time()
        if self is QuestionnaireItemType.TIME:
            return time()
        if self is QuestionnaireItemType.STRING:
            return string()
        if self is QuestionnaireItemType.TEXT:
            return text()
        if self is QuestionnaireItemType.URL:
            return url()
        if self is QuestionnaireItemType.CHOICE:
            return choice()
        if self is QuestionnaireItemType.OPEN_CHOICE:
            return open_choice()
        if self is QuestionnaireItemType.ATTACHMENT:
            return attachment()
        if self is QuestionnaireItemType.REFERENCE:
            return reference()
        if self is QuestionnaireItemType.QUANTITY:
            return quantity()
