# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import datetime as dt
import typing

from ...core.datetime_utils import serialize_datetime
from .extension import Extension
from .uri import Uri

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class QuestionnaireResponseItem(pydantic.BaseModel):
    """
    A structured set of questions and their answers. The questions are ordered and grouped into coherent subsets, corresponding to the structure of the grouping of the questionnaire being responded to.
    """

    id: typing.Optional[str] = pydantic.Field(
        default=None,
        description="Unique id for the element within a resource (for internal references). This may be any string value that does not contain spaces.",
    )
    extension: typing.Optional[typing.List[Extension]] = pydantic.Field(
        default=None,
        description="May be used to represent additional information that is not part of the basic definition of the element. To make the use of extensions safe and manageable, there is a strict set of governance applied to the definition and use of extensions. Though any implementer can define an extension, there is a set of requirements that SHALL be met as part of the definition of the extension.",
    )
    modifier_extension: typing.Optional[typing.List[Extension]] = pydantic.Field(
        alias="modifierExtension",
        default=None,
        description="May be used to represent additional information that is not part of the basic definition of the element and that modifies the understanding of the element in which it is contained and/or the understanding of the containing element's descendants. Usually modifier elements provide negation or qualification. To make the use of extensions safe and manageable, there is a strict set of governance applied to the definition and use of extensions. Though any implementer can define an extension, there is a set of requirements that SHALL be met as part of the definition of the extension. Applications processing a resource are required to check for modifier extensions. Modifier extensions SHALL NOT change the meaning of any elements on Resource or DomainResource (including cannot change the meaning of modifierExtension itself).",
    )
    link_id: typing.Optional[str] = pydantic.Field(
        alias="linkId",
        default=None,
        description="The item from the Questionnaire that corresponds to this item in the QuestionnaireResponse resource.",
    )
    definition: typing.Optional[Uri] = pydantic.Field(
        default=None, description="A reference to an [[[ElementDefinition]]] that provides the details for the item."
    )
    text: typing.Optional[str] = pydantic.Field(
        default=None,
        description="Text that is displayed above the contents of the group or as the text of the question being answered.",
    )
    answer: typing.Optional[typing.List[QuestionnaireResponseAnswer]] = pydantic.Field(
        default=None, description="The respondent's answer(s) to the question."
    )
    item: typing.Optional[typing.List[QuestionnaireResponseItem]] = pydantic.Field(
        default=None, description="Questions or sub-groups nested beneath a question or group."
    )

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        allow_population_by_field_name = True
        json_encoders = {dt.datetime: serialize_datetime}


from .questionnaire_response_answer import QuestionnaireResponseAnswer  # noqa: E402

QuestionnaireResponseItem.update_forward_refs()
