# This file was auto-generated by Fern from our API Definition.

import enum
import typing

T_Result = typing.TypeVar("T_Result")


class QuestionnaireResponseStatus(str, enum.Enum):
    """
    The position of the questionnaire response within its overall lifecycle.
    """

    IN_PROGRESS = "in-progress"
    COMPLETED = "completed"
    AMENDED = "amended"
    ENTERED_IN_ERROR = "entered-in-error"
    STOPPED = "stopped"

    def visit(
        self,
        in_progress: typing.Callable[[], T_Result],
        completed: typing.Callable[[], T_Result],
        amended: typing.Callable[[], T_Result],
        entered_in_error: typing.Callable[[], T_Result],
        stopped: typing.Callable[[], T_Result],
    ) -> T_Result:
        if self is QuestionnaireResponseStatus.IN_PROGRESS:
            return in_progress()
        if self is QuestionnaireResponseStatus.COMPLETED:
            return completed()
        if self is QuestionnaireResponseStatus.AMENDED:
            return amended()
        if self is QuestionnaireResponseStatus.ENTERED_IN_ERROR:
            return entered_in_error()
        if self is QuestionnaireResponseStatus.STOPPED:
            return stopped()
