# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import datetime as dt
import typing

from ...core.datetime_utils import serialize_datetime
from .canonical import Canonical
from .markdown import Markdown
from .related_artifact_type import RelatedArtifactType
from .url import Url

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class RelatedArtifact(pydantic.BaseModel):
    """
    Related artifacts such as additional documentation, justification, or bibliographic references.
    """

    id: typing.Optional[str] = pydantic.Field(
        default=None,
        description="Unique id for the element within a resource (for internal references). This may be any string value that does not contain spaces.",
    )
    extension: typing.Optional[typing.List[Extension]] = pydantic.Field(
        default=None,
        description="May be used to represent additional information that is not part of the basic definition of the element. To make the use of extensions safe and manageable, there is a strict set of governance applied to the definition and use of extensions. Though any implementer can define an extension, there is a set of requirements that SHALL be met as part of the definition of the extension.",
    )
    type: typing.Optional[RelatedArtifactType] = pydantic.Field(
        default=None, description="The type of relationship to the related artifact."
    )
    label: typing.Optional[str] = pydantic.Field(
        default=None,
        description="A short label that can be used to reference the citation from elsewhere in the containing artifact, such as a footnote index.",
    )
    display: typing.Optional[str] = pydantic.Field(
        default=None,
        description="A brief description of the document or knowledge resource being referenced, suitable for display to a consumer.",
    )
    citation: typing.Optional[Markdown] = pydantic.Field(
        default=None,
        description="A bibliographic citation for the related artifact. This text SHOULD be formatted according to an accepted citation format.",
    )
    url: typing.Optional[Url] = pydantic.Field(
        default=None, description="A url for the artifact that can be followed to access the actual content."
    )
    document: typing.Optional[Attachment] = pydantic.Field(
        default=None,
        description="The document being referenced, represented as an attachment. This is exclusive with the resource element.",
    )
    resource: typing.Optional[Canonical] = pydantic.Field(
        default=None,
        description="The related resource, such as a library, value set, profile, or other knowledge resource.",
    )

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        json_encoders = {dt.datetime: serialize_datetime}


from .attachment import Attachment  # noqa: E402
from .extension import Extension  # noqa: E402

RelatedArtifact.update_forward_refs()
