# This file was auto-generated by Fern from our API Definition.

import enum
import typing

T_Result = typing.TypeVar("T_Result")


class RelatedArtifactType(str, enum.Enum):
    """
    The type of relationship to the related artifact.
    """

    DOCUMENTATION = "documentation"
    JUSTIFICATION = "justification"
    CITATION = "citation"
    PREDECESSOR = "predecessor"
    SUCCESSOR = "successor"
    DERIVED_FROM = "derived-from"
    DEPENDS_ON = "depends-on"
    COMPOSED_OF = "composed-of"

    def visit(
        self,
        documentation: typing.Callable[[], T_Result],
        justification: typing.Callable[[], T_Result],
        citation: typing.Callable[[], T_Result],
        predecessor: typing.Callable[[], T_Result],
        successor: typing.Callable[[], T_Result],
        derived_from: typing.Callable[[], T_Result],
        depends_on: typing.Callable[[], T_Result],
        composed_of: typing.Callable[[], T_Result],
    ) -> T_Result:
        if self is RelatedArtifactType.DOCUMENTATION:
            return documentation()
        if self is RelatedArtifactType.JUSTIFICATION:
            return justification()
        if self is RelatedArtifactType.CITATION:
            return citation()
        if self is RelatedArtifactType.PREDECESSOR:
            return predecessor()
        if self is RelatedArtifactType.SUCCESSOR:
            return successor()
        if self is RelatedArtifactType.DERIVED_FROM:
            return derived_from()
        if self is RelatedArtifactType.DEPENDS_ON:
            return depends_on()
        if self is RelatedArtifactType.COMPOSED_OF:
            return composed_of()
