# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ...core.datetime_utils import serialize_datetime
from .address import Address
from .attachment import Attachment
from .base_resource import BaseResource
from .codeable_concept import CodeableConcept
from .contact_point import ContactPoint
from .human_name import HumanName
from .identifier import Identifier
from .period import Period
from .reference import Reference
from .related_person_communication import RelatedPersonCommunication
from .related_person_gender import RelatedPersonGender

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class RelatedPerson(BaseResource):
    """
    Information about a person that is involved in the care for a patient, but who is not the target of healthcare, nor has a formal responsibility in the care process.
    """

    resource_type: typing.Literal["RelatedPerson"] = pydantic.Field(alias="resourceType")
    identifier: typing.Optional[typing.List[Identifier]] = pydantic.Field(
        default=None, description="Identifier for a person within a particular scope."
    )
    active: typing.Optional[bool] = pydantic.Field(
        default=None, description="Whether this related person record is in active use."
    )
    patient: Reference = pydantic.Field(description="The patient this person is related to.")
    relationship: typing.Optional[typing.List[CodeableConcept]] = pydantic.Field(
        default=None, description="The nature of the relationship between a patient and the related person."
    )
    name: typing.Optional[typing.List[HumanName]] = pydantic.Field(
        default=None, description="A name associated with the person."
    )
    telecom: typing.Optional[typing.List[ContactPoint]] = pydantic.Field(
        default=None, description="A contact detail for the person, e.g. a telephone number or an email address."
    )
    gender: typing.Optional[RelatedPersonGender] = pydantic.Field(
        default=None,
        description="Administrative Gender - the gender that the person is considered to have for administration and record keeping purposes.",
    )
    birth_date: typing.Optional[dt.date] = pydantic.Field(
        alias="birthDate", default=None, description="The date on which the related person was born."
    )
    address: typing.Optional[typing.List[Address]] = pydantic.Field(
        default=None, description="Address where the related person can be contacted or visited."
    )
    photo: typing.Optional[typing.List[Attachment]] = pydantic.Field(default=None, description="Image of the person.")
    period: typing.Optional[Period] = pydantic.Field(
        default=None,
        description="The period of time during which this relationship is or was active. If there are no dates defined, then the interval is unknown.",
    )
    communication: typing.Optional[typing.List[RelatedPersonCommunication]] = pydantic.Field(
        default=None, description="A language which may be used to communicate with about the patient's health."
    )

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        allow_population_by_field_name = True
        json_encoders = {dt.datetime: serialize_datetime}
