# This file was auto-generated by Fern from our API Definition.

import enum
import typing

T_Result = typing.TypeVar("T_Result")


class ResearchElementDefinitionType(str, enum.Enum):
    """
    The type of research element, a population, an exposure, or an outcome.
    """

    POPULATION = "population"
    EXPOSURE = "exposure"
    OUTCOME = "outcome"

    def visit(
        self,
        population: typing.Callable[[], T_Result],
        exposure: typing.Callable[[], T_Result],
        outcome: typing.Callable[[], T_Result],
    ) -> T_Result:
        if self is ResearchElementDefinitionType.POPULATION:
            return population()
        if self is ResearchElementDefinitionType.EXPOSURE:
            return exposure()
        if self is ResearchElementDefinitionType.OUTCOME:
            return outcome()
