# This file was auto-generated by Fern from our API Definition.

import enum
import typing

T_Result = typing.TypeVar("T_Result")


class ResearchStudyStatus(str, enum.Enum):
    """
    The current state of the study.
    """

    ACTIVE = "active"
    ADMINISTRATIVELY_COMPLETED = "administratively-completed"
    APPROVED = "approved"
    CLOSED_TO_ACCRUAL = "closed-to-accrual"
    CLOSED_TO_ACCRUAL_AND_INTERVENTION = "closed-to-accrual-and-intervention"
    COMPLETED = "completed"
    DISAPPROVED = "disapproved"
    IN_REVIEW = "in-review"
    TEMPORARILY_CLOSED_TO_ACCRUAL = "temporarily-closed-to-accrual"
    TEMPORARILY_CLOSED_TO_ACCRUAL_AND_INTERVENTION = "temporarily-closed-to-accrual-and-intervention"
    WITHDRAWN = "withdrawn"

    def visit(
        self,
        active: typing.Callable[[], T_Result],
        administratively_completed: typing.Callable[[], T_Result],
        approved: typing.Callable[[], T_Result],
        closed_to_accrual: typing.Callable[[], T_Result],
        closed_to_accrual_and_intervention: typing.Callable[[], T_Result],
        completed: typing.Callable[[], T_Result],
        disapproved: typing.Callable[[], T_Result],
        in_review: typing.Callable[[], T_Result],
        temporarily_closed_to_accrual: typing.Callable[[], T_Result],
        temporarily_closed_to_accrual_and_intervention: typing.Callable[[], T_Result],
        withdrawn: typing.Callable[[], T_Result],
    ) -> T_Result:
        if self is ResearchStudyStatus.ACTIVE:
            return active()
        if self is ResearchStudyStatus.ADMINISTRATIVELY_COMPLETED:
            return administratively_completed()
        if self is ResearchStudyStatus.APPROVED:
            return approved()
        if self is ResearchStudyStatus.CLOSED_TO_ACCRUAL:
            return closed_to_accrual()
        if self is ResearchStudyStatus.CLOSED_TO_ACCRUAL_AND_INTERVENTION:
            return closed_to_accrual_and_intervention()
        if self is ResearchStudyStatus.COMPLETED:
            return completed()
        if self is ResearchStudyStatus.DISAPPROVED:
            return disapproved()
        if self is ResearchStudyStatus.IN_REVIEW:
            return in_review()
        if self is ResearchStudyStatus.TEMPORARILY_CLOSED_TO_ACCRUAL:
            return temporarily_closed_to_accrual()
        if self is ResearchStudyStatus.TEMPORARILY_CLOSED_TO_ACCRUAL_AND_INTERVENTION:
            return temporarily_closed_to_accrual_and_intervention()
        if self is ResearchStudyStatus.WITHDRAWN:
            return withdrawn()
