# This file was auto-generated by Fern from our API Definition.

import enum
import typing

T_Result = typing.TypeVar("T_Result")


class ResearchSubjectStatus(str, enum.Enum):
    """
    The current state of the subject.
    """

    CANDIDATE = "candidate"
    ELIGIBLE = "eligible"
    FOLLOW_UP = "follow-up"
    INELIGIBLE = "ineligible"
    NOT_REGISTERED = "not-registered"
    OFF_STUDY = "off-study"
    ON_STUDY = "on-study"
    ON_STUDY_INTERVENTION = "on-study-intervention"
    ON_STUDY_OBSERVATION = "on-study-observation"
    PENDING_ON_STUDY = "pending-on-study"
    POTENTIAL_CANDIDATE = "potential-candidate"
    SCREENING = "screening"
    WITHDRAWN = "withdrawn"

    def visit(
        self,
        candidate: typing.Callable[[], T_Result],
        eligible: typing.Callable[[], T_Result],
        follow_up: typing.Callable[[], T_Result],
        ineligible: typing.Callable[[], T_Result],
        not_registered: typing.Callable[[], T_Result],
        off_study: typing.Callable[[], T_Result],
        on_study: typing.Callable[[], T_Result],
        on_study_intervention: typing.Callable[[], T_Result],
        on_study_observation: typing.Callable[[], T_Result],
        pending_on_study: typing.Callable[[], T_Result],
        potential_candidate: typing.Callable[[], T_Result],
        screening: typing.Callable[[], T_Result],
        withdrawn: typing.Callable[[], T_Result],
    ) -> T_Result:
        if self is ResearchSubjectStatus.CANDIDATE:
            return candidate()
        if self is ResearchSubjectStatus.ELIGIBLE:
            return eligible()
        if self is ResearchSubjectStatus.FOLLOW_UP:
            return follow_up()
        if self is ResearchSubjectStatus.INELIGIBLE:
            return ineligible()
        if self is ResearchSubjectStatus.NOT_REGISTERED:
            return not_registered()
        if self is ResearchSubjectStatus.OFF_STUDY:
            return off_study()
        if self is ResearchSubjectStatus.ON_STUDY:
            return on_study()
        if self is ResearchSubjectStatus.ON_STUDY_INTERVENTION:
            return on_study_intervention()
        if self is ResearchSubjectStatus.ON_STUDY_OBSERVATION:
            return on_study_observation()
        if self is ResearchSubjectStatus.PENDING_ON_STUDY:
            return pending_on_study()
        if self is ResearchSubjectStatus.POTENTIAL_CANDIDATE:
            return potential_candidate()
        if self is ResearchSubjectStatus.SCREENING:
            return screening()
        if self is ResearchSubjectStatus.WITHDRAWN:
            return withdrawn()
