# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import datetime as dt
import typing

from ...core.datetime_utils import serialize_datetime
from .base_64_binary import Base64Binary
from .code import Code
from .instant import Instant

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class Signature(pydantic.BaseModel):
    """
    A signature along with supporting context. The signature may be a digital signature that is cryptographic in nature, or some other signature acceptable to the domain. This other signature may be as simple as a graphical image representing a hand-written signature, or a signature ceremony Different signature approaches have different utilities.
    """

    id: typing.Optional[str] = pydantic.Field(
        default=None,
        description="Unique id for the element within a resource (for internal references). This may be any string value that does not contain spaces.",
    )
    extension: typing.Optional[typing.List[Extension]] = pydantic.Field(
        default=None,
        description="May be used to represent additional information that is not part of the basic definition of the element. To make the use of extensions safe and manageable, there is a strict set of governance applied to the definition and use of extensions. Though any implementer can define an extension, there is a set of requirements that SHALL be met as part of the definition of the extension.",
    )
    type: typing.List[Coding] = pydantic.Field(
        description="An indication of the reason that the entity signed this document. This may be explicitly included as part of the signature information and can be used when determining accountability for various actions concerning the document."
    )
    when: typing.Optional[Instant] = pydantic.Field(default=None, description="When the digital signature was signed.")
    who: Reference = pydantic.Field(
        description="A reference to an application-usable description of the identity that signed (e.g. the signature used their private key)."
    )
    on_behalf_of: typing.Optional[Reference] = pydantic.Field(
        alias="onBehalfOf",
        default=None,
        description="A reference to an application-usable description of the identity that is represented by the signature.",
    )
    target_format: typing.Optional[Code] = pydantic.Field(
        alias="targetFormat",
        default=None,
        description="A mime type that indicates the technical format of the target resources signed by the signature.",
    )
    sig_format: typing.Optional[Code] = pydantic.Field(
        alias="sigFormat",
        default=None,
        description="A mime type that indicates the technical format of the signature. Important mime types are application/signature+xml for X ML DigSig, application/jose for JWS, and image/\* for a graphical image of a signature, etc.",
    )
    data: typing.Optional[Base64Binary] = pydantic.Field(
        default=None,
        description="The base64 encoding of the Signature content. When signature is not recorded electronically this element would be empty.",
    )

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        allow_population_by_field_name = True
        json_encoders = {dt.datetime: serialize_datetime}


from .coding import Coding  # noqa: E402
from .extension import Extension  # noqa: E402
from .reference import Reference  # noqa: E402

Signature.update_forward_refs()
