# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ...core.datetime_utils import serialize_datetime
from .base_resource import BaseResource
from .codeable_concept import CodeableConcept
from .identifier import Identifier
from .specimen_definition_type_tested import SpecimenDefinitionTypeTested

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class SpecimenDefinition(BaseResource):
    """
    A kind of specimen with associated set of requirements.
    """

    resource_type: typing.Literal["SpecimenDefinition"] = pydantic.Field(alias="resourceType")
    identifier: typing.Optional[Identifier] = pydantic.Field(
        default=None, description="A business identifier associated with the kind of specimen."
    )
    type_collected: typing.Optional[CodeableConcept] = pydantic.Field(
        alias="typeCollected", default=None, description="The kind of material to be collected."
    )
    patient_preparation: typing.Optional[typing.List[CodeableConcept]] = pydantic.Field(
        alias="patientPreparation", default=None, description="Preparation of the patient for specimen collection."
    )
    time_aspect: typing.Optional[str] = pydantic.Field(
        alias="timeAspect", default=None, description="Time aspect of specimen collection (duration or offset)."
    )
    collection: typing.Optional[typing.List[CodeableConcept]] = pydantic.Field(
        default=None, description="The action to be performed for collecting the specimen."
    )
    type_tested: typing.Optional[typing.List[SpecimenDefinitionTypeTested]] = pydantic.Field(
        alias="typeTested",
        default=None,
        description="Specimen conditioned in a container as expected by the testing laboratory.",
    )

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        allow_population_by_field_name = True
        json_encoders = {dt.datetime: serialize_datetime}
