# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ...core.datetime_utils import serialize_datetime
from .codeable_concept import CodeableConcept
from .extension import Extension
from .quantity import Quantity
from .specimen_definition_additive import SpecimenDefinitionAdditive

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class SpecimenDefinitionContainer(pydantic.BaseModel):
    """
    A kind of specimen with associated set of requirements.
    """

    id: typing.Optional[str] = pydantic.Field(
        default=None,
        description="Unique id for the element within a resource (for internal references). This may be any string value that does not contain spaces.",
    )
    extension: typing.Optional[typing.List[Extension]] = pydantic.Field(
        default=None,
        description="May be used to represent additional information that is not part of the basic definition of the element. To make the use of extensions safe and manageable, there is a strict set of governance applied to the definition and use of extensions. Though any implementer can define an extension, there is a set of requirements that SHALL be met as part of the definition of the extension.",
    )
    modifier_extension: typing.Optional[typing.List[Extension]] = pydantic.Field(
        alias="modifierExtension",
        default=None,
        description="May be used to represent additional information that is not part of the basic definition of the element and that modifies the understanding of the element in which it is contained and/or the understanding of the containing element's descendants. Usually modifier elements provide negation or qualification. To make the use of extensions safe and manageable, there is a strict set of governance applied to the definition and use of extensions. Though any implementer can define an extension, there is a set of requirements that SHALL be met as part of the definition of the extension. Applications processing a resource are required to check for modifier extensions. Modifier extensions SHALL NOT change the meaning of any elements on Resource or DomainResource (including cannot change the meaning of modifierExtension itself).",
    )
    material: typing.Optional[CodeableConcept] = pydantic.Field(
        default=None, description="The type of material of the container."
    )
    type: typing.Optional[CodeableConcept] = pydantic.Field(
        default=None, description="The type of container used to contain this kind of specimen."
    )
    cap: typing.Optional[CodeableConcept] = pydantic.Field(default=None, description="Color of container cap.")
    description: typing.Optional[str] = pydantic.Field(
        default=None, description="The textual description of the kind of container."
    )
    capacity: typing.Optional[Quantity] = pydantic.Field(
        default=None, description="The capacity (volume or other measure) of this kind of container."
    )
    minimum_volume_quantity: typing.Optional[Quantity] = pydantic.Field(
        alias="minimumVolumeQuantity",
        default=None,
        description="The minimum volume to be conditioned in the container.",
    )
    minimum_volume_string: typing.Optional[str] = pydantic.Field(
        alias="minimumVolumeString", default=None, description="The minimum volume to be conditioned in the container."
    )
    additive: typing.Optional[typing.List[SpecimenDefinitionAdditive]] = pydantic.Field(
        default=None,
        description="Substance introduced in the kind of container to preserve, maintain or enhance the specimen. Examples: Formalin, Citrate, EDTA.",
    )
    preparation: typing.Optional[str] = pydantic.Field(
        default=None,
        description="Special processing that should be applied to the container for this kind of specimen.",
    )

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        allow_population_by_field_name = True
        json_encoders = {dt.datetime: serialize_datetime}
