# This file was auto-generated by Fern from our API Definition.

import enum
import typing

T_Result = typing.TypeVar("T_Result")


class SpecimenStatus(str, enum.Enum):
    """
    The availability of the specimen.
    """

    AVAILABLE = "available"
    UNAVAILABLE = "unavailable"
    UNSATISFACTORY = "unsatisfactory"
    ENTERED_IN_ERROR = "entered-in-error"

    def visit(
        self,
        available: typing.Callable[[], T_Result],
        unavailable: typing.Callable[[], T_Result],
        unsatisfactory: typing.Callable[[], T_Result],
        entered_in_error: typing.Callable[[], T_Result],
    ) -> T_Result:
        if self is SpecimenStatus.AVAILABLE:
            return available()
        if self is SpecimenStatus.UNAVAILABLE:
            return unavailable()
        if self is SpecimenStatus.UNSATISFACTORY:
            return unsatisfactory()
        if self is SpecimenStatus.ENTERED_IN_ERROR:
            return entered_in_error()
