# This file was auto-generated by Fern from our API Definition.

import enum
import typing

T_Result = typing.TypeVar("T_Result")


class StructureDefinitionKind(str, enum.Enum):
    """
    Defines the kind of structure that this definition is describing.
    """

    PRIMITIVE_TYPE = "primitive-type"
    COMPLEX_TYPE = "complex-type"
    RESOURCE = "resource"
    LOGICAL = "logical"

    def visit(
        self,
        primitive_type: typing.Callable[[], T_Result],
        complex_type: typing.Callable[[], T_Result],
        resource: typing.Callable[[], T_Result],
        logical: typing.Callable[[], T_Result],
    ) -> T_Result:
        if self is StructureDefinitionKind.PRIMITIVE_TYPE:
            return primitive_type()
        if self is StructureDefinitionKind.COMPLEX_TYPE:
            return complex_type()
        if self is StructureDefinitionKind.RESOURCE:
            return resource()
        if self is StructureDefinitionKind.LOGICAL:
            return logical()
