# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import datetime as dt
import typing

from ...core.datetime_utils import serialize_datetime
from .extension import Extension
from .id import Id
from .structure_map_dependent import StructureMapDependent
from .structure_map_source import StructureMapSource
from .structure_map_target import StructureMapTarget

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class StructureMapRule(pydantic.BaseModel):
    """
    A Map of relationships between 2 structures that can be used to transform data.
    """

    id: typing.Optional[str] = pydantic.Field(
        default=None,
        description="Unique id for the element within a resource (for internal references). This may be any string value that does not contain spaces.",
    )
    extension: typing.Optional[typing.List[Extension]] = pydantic.Field(
        default=None,
        description="May be used to represent additional information that is not part of the basic definition of the element. To make the use of extensions safe and manageable, there is a strict set of governance applied to the definition and use of extensions. Though any implementer can define an extension, there is a set of requirements that SHALL be met as part of the definition of the extension.",
    )
    modifier_extension: typing.Optional[typing.List[Extension]] = pydantic.Field(
        alias="modifierExtension",
        default=None,
        description="May be used to represent additional information that is not part of the basic definition of the element and that modifies the understanding of the element in which it is contained and/or the understanding of the containing element's descendants. Usually modifier elements provide negation or qualification. To make the use of extensions safe and manageable, there is a strict set of governance applied to the definition and use of extensions. Though any implementer can define an extension, there is a set of requirements that SHALL be met as part of the definition of the extension. Applications processing a resource are required to check for modifier extensions. Modifier extensions SHALL NOT change the meaning of any elements on Resource or DomainResource (including cannot change the meaning of modifierExtension itself).",
    )
    name: typing.Optional[Id] = pydantic.Field(default=None, description="Name of the rule for internal references.")
    source: typing.List[StructureMapSource] = pydantic.Field(description="Source inputs to the mapping.")
    target: typing.Optional[typing.List[StructureMapTarget]] = pydantic.Field(
        default=None, description="Content to create because of this mapping rule."
    )
    rule: typing.Optional[typing.List[StructureMapRule]] = pydantic.Field(
        default=None, description="Rules contained in this rule."
    )
    dependent: typing.Optional[typing.List[StructureMapDependent]] = pydantic.Field(
        default=None, description="Which other rules to apply in the context of this rule."
    )
    documentation: typing.Optional[str] = pydantic.Field(
        default=None, description="Documentation for this instance of data."
    )

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        allow_population_by_field_name = True
        json_encoders = {dt.datetime: serialize_datetime}


StructureMapRule.update_forward_refs()
