# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ...core.datetime_utils import serialize_datetime
from .extension import Extension
from .id import Id
from .structure_map_parameter import StructureMapParameter
from .structure_map_target_context_type import StructureMapTargetContextType
from .structure_map_target_list_mode_item import StructureMapTargetListModeItem
from .structure_map_target_transform import StructureMapTargetTransform

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class StructureMapTarget(pydantic.BaseModel):
    """
    A Map of relationships between 2 structures that can be used to transform data.
    """

    id: typing.Optional[str] = pydantic.Field(
        default=None,
        description="Unique id for the element within a resource (for internal references). This may be any string value that does not contain spaces.",
    )
    extension: typing.Optional[typing.List[Extension]] = pydantic.Field(
        default=None,
        description="May be used to represent additional information that is not part of the basic definition of the element. To make the use of extensions safe and manageable, there is a strict set of governance applied to the definition and use of extensions. Though any implementer can define an extension, there is a set of requirements that SHALL be met as part of the definition of the extension.",
    )
    modifier_extension: typing.Optional[typing.List[Extension]] = pydantic.Field(
        alias="modifierExtension",
        default=None,
        description="May be used to represent additional information that is not part of the basic definition of the element and that modifies the understanding of the element in which it is contained and/or the understanding of the containing element's descendants. Usually modifier elements provide negation or qualification. To make the use of extensions safe and manageable, there is a strict set of governance applied to the definition and use of extensions. Though any implementer can define an extension, there is a set of requirements that SHALL be met as part of the definition of the extension. Applications processing a resource are required to check for modifier extensions. Modifier extensions SHALL NOT change the meaning of any elements on Resource or DomainResource (including cannot change the meaning of modifierExtension itself).",
    )
    context: typing.Optional[Id] = pydantic.Field(default=None, description="Type or variable this rule applies to.")
    context_type: typing.Optional[StructureMapTargetContextType] = pydantic.Field(
        alias="contextType", default=None, description="How to interpret the context."
    )
    element: typing.Optional[str] = pydantic.Field(default=None, description="Field to create in the context.")
    variable: typing.Optional[Id] = pydantic.Field(
        default=None, description="Named context for field, if desired, and a field is specified."
    )
    list_mode: typing.Optional[typing.List[StructureMapTargetListModeItem]] = pydantic.Field(
        alias="listMode", default=None, description="If field is a list, how to manage the list."
    )
    list_rule_id: typing.Optional[Id] = pydantic.Field(
        alias="listRuleId", default=None, description="Internal rule reference for shared list items."
    )
    transform: typing.Optional[StructureMapTargetTransform] = pydantic.Field(
        default=None, description="How the data is copied / created."
    )
    parameter: typing.Optional[typing.List[StructureMapParameter]] = pydantic.Field(
        default=None, description="Parameters to the transform."
    )

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        allow_population_by_field_name = True
        json_encoders = {dt.datetime: serialize_datetime}
