# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ...core.datetime_utils import serialize_datetime
from .base_resource import BaseResource
from .codeable_concept import CodeableConcept
from .identifier import Identifier
from .substance_source_material_fraction_description import SubstanceSourceMaterialFractionDescription
from .substance_source_material_organism import SubstanceSourceMaterialOrganism
from .substance_source_material_part_description import SubstanceSourceMaterialPartDescription

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class SubstanceSourceMaterial(BaseResource):
    """
    Source material shall capture information on the taxonomic and anatomical origins as well as the fraction of a material that can result in or can be modified to form a substance. This set of data elements shall be used to define polymer substances isolated from biological matrices. Taxonomic and anatomical origins shall be described using a controlled vocabulary as required. This information is captured for naturally derived polymers ( . starch) and structurally diverse substances. For Organisms belonging to the Kingdom Plantae the Substance level defines the fresh material of a single species or infraspecies, the Herbal Drug and the Herbal preparation. For Herbal preparations, the fraction information will be captured at the Substance information level and additional information for herbal extracts will be captured at the Specified Substance Group 1 information level. See for further explanation the Substance Class: Structurally Diverse and the herbal annex.
    """

    resource_type: typing.Literal["SubstanceSourceMaterial"] = pydantic.Field(alias="resourceType")
    source_material_class: typing.Optional[CodeableConcept] = pydantic.Field(
        alias="sourceMaterialClass",
        default=None,
        description="General high level classification of the source material specific to the origin of the material.",
    )
    source_material_type: typing.Optional[CodeableConcept] = pydantic.Field(
        alias="sourceMaterialType",
        default=None,
        description="The type of the source material shall be specified based on a controlled vocabulary. For vaccines, this subclause refers to the class of infectious agent.",
    )
    source_material_state: typing.Optional[CodeableConcept] = pydantic.Field(
        alias="sourceMaterialState", default=None, description="The state of the source material when extracted."
    )
    organism_id: typing.Optional[Identifier] = pydantic.Field(
        alias="organismId",
        default=None,
        description="The unique identifier associated with the source material parent organism shall be specified.",
    )
    organism_name: typing.Optional[str] = pydantic.Field(
        alias="organismName",
        default=None,
        description="The organism accepted Scientific name shall be provided based on the organism taxonomy.",
    )
    parent_substance_id: typing.Optional[typing.List[Identifier]] = pydantic.Field(
        alias="parentSubstanceId",
        default=None,
        description="The parent of the herbal drug Ginkgo biloba, Leaf is the substance ID of the substance (fresh) of Ginkgo biloba L. or Ginkgo biloba L. (Whole plant).",
    )
    parent_substance_name: typing.Optional[typing.List[str]] = pydantic.Field(
        alias="parentSubstanceName",
        default=None,
        description="The parent substance of the Herbal Drug, or Herbal preparation.",
    )
    country_of_origin: typing.Optional[typing.List[CodeableConcept]] = pydantic.Field(
        alias="countryOfOrigin",
        default=None,
        description="The country where the plant material is harvested or the countries where the plasma is sourced from as laid down in accordance with the Plasma Master File. For “Plasma-derived substances” the attribute country of origin provides information about the countries used for the manufacturing of the Cryopoor plama or Crioprecipitate.",
    )
    geographical_location: typing.Optional[typing.List[str]] = pydantic.Field(
        alias="geographicalLocation",
        default=None,
        description="The place/region where the plant is harvested or the places/regions where the animal source material has its habitat.",
    )
    development_stage: typing.Optional[CodeableConcept] = pydantic.Field(
        alias="developmentStage",
        default=None,
        description="Stage of life for animals, plants, insects and microorganisms. This information shall be provided only when the substance is significantly different in these stages (e.g. foetal bovine serum).",
    )
    fraction_description: typing.Optional[typing.List[SubstanceSourceMaterialFractionDescription]] = pydantic.Field(
        alias="fractionDescription",
        default=None,
        description="Many complex materials are fractions of parts of plants, animals, or minerals. Fraction elements are often necessary to define both Substances and Specified Group 1 Substances. For substances derived from Plants, fraction information will be captured at the Substance information level ( . Oils, Juices and Exudates). Additional information for Extracts, such as extraction solvent composition, will be captured at the Specified Substance Group 1 information level. For plasma-derived products fraction information will be captured at the Substance and the Specified Substance Group 1 levels.",
    )
    organism: typing.Optional[SubstanceSourceMaterialOrganism] = pydantic.Field(
        default=None,
        description="This subclause describes the organism which the substance is derived from. For vaccines, the parent organism shall be specified based on these subclause elements. As an example, full taxonomy will be described for the Substance Name: ., Leaf.",
    )
    part_description: typing.Optional[typing.List[SubstanceSourceMaterialPartDescription]] = pydantic.Field(
        alias="partDescription", default=None, description="To do."
    )

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        allow_population_by_field_name = True
        json_encoders = {dt.datetime: serialize_datetime}
