# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ...core.datetime_utils import serialize_datetime
from .codeable_concept import CodeableConcept
from .extension import Extension
from .substance_source_material_author import SubstanceSourceMaterialAuthor
from .substance_source_material_hybrid import SubstanceSourceMaterialHybrid
from .substance_source_material_organism_general import SubstanceSourceMaterialOrganismGeneral

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class SubstanceSourceMaterialOrganism(pydantic.BaseModel):
    """
    Source material shall capture information on the taxonomic and anatomical origins as well as the fraction of a material that can result in or can be modified to form a substance. This set of data elements shall be used to define polymer substances isolated from biological matrices. Taxonomic and anatomical origins shall be described using a controlled vocabulary as required. This information is captured for naturally derived polymers ( . starch) and structurally diverse substances. For Organisms belonging to the Kingdom Plantae the Substance level defines the fresh material of a single species or infraspecies, the Herbal Drug and the Herbal preparation. For Herbal preparations, the fraction information will be captured at the Substance information level and additional information for herbal extracts will be captured at the Specified Substance Group 1 information level. See for further explanation the Substance Class: Structurally Diverse and the herbal annex.
    """

    id: typing.Optional[str] = pydantic.Field(
        default=None,
        description="Unique id for the element within a resource (for internal references). This may be any string value that does not contain spaces.",
    )
    extension: typing.Optional[typing.List[Extension]] = pydantic.Field(
        default=None,
        description="May be used to represent additional information that is not part of the basic definition of the element. To make the use of extensions safe and manageable, there is a strict set of governance applied to the definition and use of extensions. Though any implementer can define an extension, there is a set of requirements that SHALL be met as part of the definition of the extension.",
    )
    modifier_extension: typing.Optional[typing.List[Extension]] = pydantic.Field(
        alias="modifierExtension",
        default=None,
        description="May be used to represent additional information that is not part of the basic definition of the element and that modifies the understanding of the element in which it is contained and/or the understanding of the containing element's descendants. Usually modifier elements provide negation or qualification. To make the use of extensions safe and manageable, there is a strict set of governance applied to the definition and use of extensions. Though any implementer can define an extension, there is a set of requirements that SHALL be met as part of the definition of the extension. Applications processing a resource are required to check for modifier extensions. Modifier extensions SHALL NOT change the meaning of any elements on Resource or DomainResource (including cannot change the meaning of modifierExtension itself).",
    )
    family: typing.Optional[CodeableConcept] = pydantic.Field(
        default=None, description="The family of an organism shall be specified."
    )
    genus: typing.Optional[CodeableConcept] = pydantic.Field(
        default=None,
        description="The genus of an organism shall be specified; refers to the Latin epithet of the genus element of the plant/animal scientific name; it is present in names for genera, species and infraspecies.",
    )
    species: typing.Optional[CodeableConcept] = pydantic.Field(
        default=None,
        description="The species of an organism shall be specified; refers to the Latin epithet of the species of the plant/animal; it is present in names for species and infraspecies.",
    )
    intraspecific_type: typing.Optional[CodeableConcept] = pydantic.Field(
        alias="intraspecificType", default=None, description="The Intraspecific type of an organism shall be specified."
    )
    intraspecific_description: typing.Optional[str] = pydantic.Field(
        alias="intraspecificDescription",
        default=None,
        description="The intraspecific description of an organism shall be specified based on a controlled vocabulary. For Influenza Vaccine, the intraspecific description shall contain the syntax of the antigen in line with the WHO convention.",
    )
    author: typing.Optional[typing.List[SubstanceSourceMaterialAuthor]] = pydantic.Field(
        default=None, description="4.9.13.6.1 Author type (Conditional)."
    )
    hybrid: typing.Optional[SubstanceSourceMaterialHybrid] = pydantic.Field(
        default=None, description="4.9.13.8.1 Hybrid species maternal organism ID (Optional)."
    )
    organism_general: typing.Optional[SubstanceSourceMaterialOrganismGeneral] = pydantic.Field(
        alias="organismGeneral", default=None, description="4.9.13.7.1 Kingdom (Conditional)."
    )

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        allow_population_by_field_name = True
        json_encoders = {dt.datetime: serialize_datetime}
