# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ...core.datetime_utils import serialize_datetime
from .base_resource import BaseResource
from .codeable_concept import CodeableConcept
from .identifier import Identifier
from .reference import Reference
from .substance_specification_code import SubstanceSpecificationCode
from .substance_specification_moiety import SubstanceSpecificationMoiety
from .substance_specification_molecular_weight import SubstanceSpecificationMolecularWeight
from .substance_specification_name import SubstanceSpecificationName
from .substance_specification_property import SubstanceSpecificationProperty
from .substance_specification_relationship import SubstanceSpecificationRelationship
from .substance_specification_structure import SubstanceSpecificationStructure

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class SubstanceSpecification(BaseResource):
    """
    The detailed description of a substance, typically at a level beyond what is used for prescribing.
    """

    resource_type: typing.Literal["SubstanceSpecification"] = pydantic.Field(alias="resourceType")
    identifier: typing.Optional[Identifier] = pydantic.Field(
        default=None, description="Identifier by which this substance is known."
    )
    type: typing.Optional[CodeableConcept] = pydantic.Field(
        default=None, description="High level categorization, e.g. polymer or nucleic acid."
    )
    status: typing.Optional[CodeableConcept] = pydantic.Field(
        default=None, description="Status of substance within the catalogue e.g. approved."
    )
    domain: typing.Optional[CodeableConcept] = pydantic.Field(
        default=None, description="If the substance applies to only human or veterinary use."
    )
    description: typing.Optional[str] = pydantic.Field(
        default=None, description="Textual description of the substance."
    )
    source: typing.Optional[typing.List[Reference]] = pydantic.Field(default=None, description="Supporting literature.")
    comment: typing.Optional[str] = pydantic.Field(
        default=None, description="Textual comment about this record of a substance."
    )
    moiety: typing.Optional[typing.List[SubstanceSpecificationMoiety]] = pydantic.Field(
        default=None, description="Moiety, for structural modifications."
    )
    property: typing.Optional[typing.List[SubstanceSpecificationProperty]] = pydantic.Field(
        default=None,
        description="General specifications for this substance, including how it is related to other substances.",
    )
    reference_information: typing.Optional[Reference] = pydantic.Field(
        alias="referenceInformation", default=None, description="General information detailing this substance."
    )
    structure: typing.Optional[SubstanceSpecificationStructure] = pydantic.Field(
        default=None, description="Structural information."
    )
    code: typing.Optional[typing.List[SubstanceSpecificationCode]] = pydantic.Field(
        default=None, description="Codes associated with the substance."
    )
    name: typing.Optional[typing.List[SubstanceSpecificationName]] = pydantic.Field(
        default=None, description="Names applicable to this substance."
    )
    molecular_weight: typing.Optional[typing.List[SubstanceSpecificationMolecularWeight]] = pydantic.Field(
        alias="molecularWeight",
        default=None,
        description="The molecular weight or weight range (for proteins, polymers or nucleic acids).",
    )
    relationship: typing.Optional[typing.List[SubstanceSpecificationRelationship]] = pydantic.Field(
        default=None, description="A link between this substance and another, with details of the relationship."
    )
    nucleic_acid: typing.Optional[Reference] = pydantic.Field(
        alias="nucleicAcid", default=None, description="Data items specific to nucleic acids."
    )
    polymer: typing.Optional[Reference] = pydantic.Field(default=None, description="Data items specific to polymers.")
    protein: typing.Optional[Reference] = pydantic.Field(default=None, description="Data items specific to proteins.")
    source_material: typing.Optional[Reference] = pydantic.Field(
        alias="sourceMaterial", default=None, description="Material or taxonomic/anatomical source for the substance."
    )

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        allow_population_by_field_name = True
        json_encoders = {dt.datetime: serialize_datetime}
