# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ...core.datetime_utils import serialize_datetime
from .codeable_concept import CodeableConcept
from .extension import Extension
from .quantity import Quantity
from .range import Range
from .ratio import Ratio
from .reference import Reference

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class SubstanceSpecificationRelationship(pydantic.BaseModel):
    """
    The detailed description of a substance, typically at a level beyond what is used for prescribing.
    """

    id: typing.Optional[str] = pydantic.Field(
        default=None,
        description="Unique id for the element within a resource (for internal references). This may be any string value that does not contain spaces.",
    )
    extension: typing.Optional[typing.List[Extension]] = pydantic.Field(
        default=None,
        description="May be used to represent additional information that is not part of the basic definition of the element. To make the use of extensions safe and manageable, there is a strict set of governance applied to the definition and use of extensions. Though any implementer can define an extension, there is a set of requirements that SHALL be met as part of the definition of the extension.",
    )
    modifier_extension: typing.Optional[typing.List[Extension]] = pydantic.Field(
        alias="modifierExtension",
        default=None,
        description="May be used to represent additional information that is not part of the basic definition of the element and that modifies the understanding of the element in which it is contained and/or the understanding of the containing element's descendants. Usually modifier elements provide negation or qualification. To make the use of extensions safe and manageable, there is a strict set of governance applied to the definition and use of extensions. Though any implementer can define an extension, there is a set of requirements that SHALL be met as part of the definition of the extension. Applications processing a resource are required to check for modifier extensions. Modifier extensions SHALL NOT change the meaning of any elements on Resource or DomainResource (including cannot change the meaning of modifierExtension itself).",
    )
    substance_reference: typing.Optional[Reference] = pydantic.Field(
        alias="substanceReference",
        default=None,
        description="A pointer to another substance, as a resource or just a representational code.",
    )
    substance_codeable_concept: typing.Optional[CodeableConcept] = pydantic.Field(
        alias="substanceCodeableConcept",
        default=None,
        description="A pointer to another substance, as a resource or just a representational code.",
    )
    relationship: typing.Optional[CodeableConcept] = pydantic.Field(
        default=None, description='For example "salt to parent", "active moiety", "starting material".'
    )
    is_defining: typing.Optional[bool] = pydantic.Field(
        alias="isDefining",
        default=None,
        description="For example where an enzyme strongly bonds with a particular substance, this is a defining relationship for that enzyme, out of several possible substance relationships.",
    )
    amount_quantity: typing.Optional[Quantity] = pydantic.Field(
        alias="amountQuantity",
        default=None,
        description="A numeric factor for the relationship, for instance to express that the salt of a substance has some percentage of the active substance in relation to some other.",
    )
    amount_range: typing.Optional[Range] = pydantic.Field(
        alias="amountRange",
        default=None,
        description="A numeric factor for the relationship, for instance to express that the salt of a substance has some percentage of the active substance in relation to some other.",
    )
    amount_ratio: typing.Optional[Ratio] = pydantic.Field(
        alias="amountRatio",
        default=None,
        description="A numeric factor for the relationship, for instance to express that the salt of a substance has some percentage of the active substance in relation to some other.",
    )
    amount_string: typing.Optional[str] = pydantic.Field(
        alias="amountString",
        default=None,
        description="A numeric factor for the relationship, for instance to express that the salt of a substance has some percentage of the active substance in relation to some other.",
    )
    amount_ratio_low_limit: typing.Optional[Ratio] = pydantic.Field(
        alias="amountRatioLowLimit", default=None, description="For use when the numeric."
    )
    amount_type: typing.Optional[CodeableConcept] = pydantic.Field(
        alias="amountType",
        default=None,
        description='An operator for the amount, for example "average", "approximately", "less than".',
    )
    source: typing.Optional[typing.List[Reference]] = pydantic.Field(default=None, description="Supporting literature.")

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        allow_population_by_field_name = True
        json_encoders = {dt.datetime: serialize_datetime}
