# This file was auto-generated by Fern from our API Definition.

import enum
import typing

T_Result = typing.TypeVar("T_Result")


class SubstanceStatus(str, enum.Enum):
    """
    A code to indicate if the substance is actively used.
    """

    ACTIVE = "active"
    INACTIVE = "inactive"
    ENTERED_IN_ERROR = "entered-in-error"

    def visit(
        self,
        active: typing.Callable[[], T_Result],
        inactive: typing.Callable[[], T_Result],
        entered_in_error: typing.Callable[[], T_Result],
    ) -> T_Result:
        if self is SubstanceStatus.ACTIVE:
            return active()
        if self is SubstanceStatus.INACTIVE:
            return inactive()
        if self is SubstanceStatus.ENTERED_IN_ERROR:
            return entered_in_error()
