# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ...core.datetime_utils import serialize_datetime
from .base_resource import BaseResource
from .codeable_concept import CodeableConcept
from .identifier import Identifier
from .period import Period
from .reference import Reference
from .supply_delivery_status import SupplyDeliveryStatus
from .supply_delivery_supplied_item import SupplyDeliverySuppliedItem
from .timing import Timing

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class SupplyDelivery(BaseResource):
    """
    Record of delivery of what is supplied.
    """

    resource_type: typing.Literal["SupplyDelivery"] = pydantic.Field(alias="resourceType")
    identifier: typing.Optional[typing.List[Identifier]] = pydantic.Field(
        default=None,
        description="Identifier for the supply delivery event that is used to identify it across multiple disparate systems.",
    )
    based_on: typing.Optional[typing.List[Reference]] = pydantic.Field(
        alias="basedOn",
        default=None,
        description="A plan, proposal or order that is fulfilled in whole or in part by this event.",
    )
    part_of: typing.Optional[typing.List[Reference]] = pydantic.Field(
        alias="partOf",
        default=None,
        description="A larger event of which this particular event is a component or step.",
    )
    status: typing.Optional[SupplyDeliveryStatus] = pydantic.Field(
        default=None, description="A code specifying the state of the dispense event."
    )
    patient: typing.Optional[Reference] = pydantic.Field(
        default=None, description="A link to a resource representing the person whom the delivered item is for."
    )
    type: typing.Optional[CodeableConcept] = pydantic.Field(
        default=None,
        description="Indicates the type of dispensing event that is performed. Examples include: Trial Fill, Completion of Trial, Partial Fill, Emergency Fill, Samples, etc.",
    )
    supplied_item: typing.Optional[SupplyDeliverySuppliedItem] = pydantic.Field(
        alias="suppliedItem", default=None, description="The item that is being delivered or has been supplied."
    )
    occurrence_date_time: typing.Optional[str] = pydantic.Field(
        alias="occurrenceDateTime", default=None, description="The date or time(s) the activity occurred."
    )
    occurrence_period: typing.Optional[Period] = pydantic.Field(
        alias="occurrencePeriod", default=None, description="The date or time(s) the activity occurred."
    )
    occurrence_timing: typing.Optional[Timing] = pydantic.Field(
        alias="occurrenceTiming", default=None, description="The date or time(s) the activity occurred."
    )
    supplier: typing.Optional[Reference] = pydantic.Field(
        default=None, description="The individual responsible for dispensing the medication, supplier or device."
    )
    destination: typing.Optional[Reference] = pydantic.Field(
        default=None,
        description="Identification of the facility/location where the Supply was shipped to, as part of the dispense event.",
    )
    receiver: typing.Optional[typing.List[Reference]] = pydantic.Field(
        default=None, description="Identifies the person who picked up the Supply."
    )

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        allow_population_by_field_name = True
        json_encoders = {dt.datetime: serialize_datetime}
