# This file was auto-generated by Fern from our API Definition.

import enum
import typing

T_Result = typing.TypeVar("T_Result")


class TaskIntent(str, enum.Enum):
    """
    Indicates the "level" of actionability associated with the Task, i.e. i+R[9]Cs this a proposed task, a planned task, an actionable task, etc.
    """

    UNKNOWN = "unknown"
    PROPOSAL = "proposal"
    PLAN = "plan"
    ORDER = "order"
    ORIGINAL_ORDER = "original-order"
    REFLEX_ORDER = "reflex-order"
    FILLER_ORDER = "filler-order"
    INSTANCE_ORDER = "instance-order"
    OPTION = "option"

    def visit(
        self,
        unknown: typing.Callable[[], T_Result],
        proposal: typing.Callable[[], T_Result],
        plan: typing.Callable[[], T_Result],
        order: typing.Callable[[], T_Result],
        original_order: typing.Callable[[], T_Result],
        reflex_order: typing.Callable[[], T_Result],
        filler_order: typing.Callable[[], T_Result],
        instance_order: typing.Callable[[], T_Result],
        option: typing.Callable[[], T_Result],
    ) -> T_Result:
        if self is TaskIntent.UNKNOWN:
            return unknown()
        if self is TaskIntent.PROPOSAL:
            return proposal()
        if self is TaskIntent.PLAN:
            return plan()
        if self is TaskIntent.ORDER:
            return order()
        if self is TaskIntent.ORIGINAL_ORDER:
            return original_order()
        if self is TaskIntent.REFLEX_ORDER:
            return reflex_order()
        if self is TaskIntent.FILLER_ORDER:
            return filler_order()
        if self is TaskIntent.INSTANCE_ORDER:
            return instance_order()
        if self is TaskIntent.OPTION:
            return option()
