# This file was auto-generated by Fern from our API Definition.

import enum
import typing

T_Result = typing.TypeVar("T_Result")


class TestReportStatus(str, enum.Enum):
    """
    The current state of this test report.
    """

    COMPLETED = "completed"
    IN_PROGRESS = "in-progress"
    WAITING = "waiting"
    STOPPED = "stopped"
    ENTERED_IN_ERROR = "entered-in-error"

    def visit(
        self,
        completed: typing.Callable[[], T_Result],
        in_progress: typing.Callable[[], T_Result],
        waiting: typing.Callable[[], T_Result],
        stopped: typing.Callable[[], T_Result],
        entered_in_error: typing.Callable[[], T_Result],
    ) -> T_Result:
        if self is TestReportStatus.COMPLETED:
            return completed()
        if self is TestReportStatus.IN_PROGRESS:
            return in_progress()
        if self is TestReportStatus.WAITING:
            return waiting()
        if self is TestReportStatus.STOPPED:
            return stopped()
        if self is TestReportStatus.ENTERED_IN_ERROR:
            return entered_in_error()
