# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import datetime as dt
import typing

from ...core.datetime_utils import serialize_datetime
from .trigger_definition_type import TriggerDefinitionType

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class TriggerDefinition(pydantic.BaseModel):
    """
    A description of a triggering event. Triggering events can be named events, data events, or periodic, as determined by the type element.
    """

    id: typing.Optional[str] = pydantic.Field(
        default=None,
        description="Unique id for the element within a resource (for internal references). This may be any string value that does not contain spaces.",
    )
    extension: typing.Optional[typing.List[Extension]] = pydantic.Field(
        default=None,
        description="May be used to represent additional information that is not part of the basic definition of the element. To make the use of extensions safe and manageable, there is a strict set of governance applied to the definition and use of extensions. Though any implementer can define an extension, there is a set of requirements that SHALL be met as part of the definition of the extension.",
    )
    type: typing.Optional[TriggerDefinitionType] = pydantic.Field(
        default=None, description="The type of triggering event."
    )
    name: typing.Optional[str] = pydantic.Field(
        default=None,
        description="A formal name for the event. This may be an absolute URI that identifies the event formally (e.g. from a trigger registry), or a simple relative URI that identifies the event in a local context.",
    )
    timing_timing: typing.Optional[Timing] = pydantic.Field(
        alias="timingTiming", default=None, description="The timing of the event (if this is a periodic trigger)."
    )
    timing_reference: typing.Optional[Reference] = pydantic.Field(
        alias="timingReference", default=None, description="The timing of the event (if this is a periodic trigger)."
    )
    timing_date: typing.Optional[str] = pydantic.Field(
        alias="timingDate", default=None, description="The timing of the event (if this is a periodic trigger)."
    )
    timing_date_time: typing.Optional[str] = pydantic.Field(
        alias="timingDateTime", default=None, description="The timing of the event (if this is a periodic trigger)."
    )
    data: typing.Optional[typing.List[DataRequirement]] = pydantic.Field(
        default=None,
        description="The triggering data of the event (if this is a data trigger). If more than one data is requirement is specified, then all the data requirements must be true.",
    )
    condition: typing.Optional[Expression] = pydantic.Field(
        default=None,
        description="A boolean-valued expression that is evaluated in the context of the container of the trigger definition and returns whether or not the trigger fires.",
    )

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        allow_population_by_field_name = True
        json_encoders = {dt.datetime: serialize_datetime}


from .data_requirement import DataRequirement  # noqa: E402
from .expression import Expression  # noqa: E402
from .extension import Extension  # noqa: E402
from .reference import Reference  # noqa: E402
from .timing import Timing  # noqa: E402

TriggerDefinition.update_forward_refs()
