# This file was auto-generated by Fern from our API Definition.

import enum
import typing

T_Result = typing.TypeVar("T_Result")


class TriggerDefinitionType(str, enum.Enum):
    """
    The type of triggering event.
    """

    NAMED_EVENT = "named-event"
    PERIODIC = "periodic"
    DATA_CHANGED = "data-changed"
    DATA_ADDED = "data-added"
    DATA_MODIFIED = "data-modified"
    DATA_REMOVED = "data-removed"
    DATA_ACCESSED = "data-accessed"
    DATA_ACCESS_ENDED = "data-access-ended"

    def visit(
        self,
        named_event: typing.Callable[[], T_Result],
        periodic: typing.Callable[[], T_Result],
        data_changed: typing.Callable[[], T_Result],
        data_added: typing.Callable[[], T_Result],
        data_modified: typing.Callable[[], T_Result],
        data_removed: typing.Callable[[], T_Result],
        data_accessed: typing.Callable[[], T_Result],
        data_access_ended: typing.Callable[[], T_Result],
    ) -> T_Result:
        if self is TriggerDefinitionType.NAMED_EVENT:
            return named_event()
        if self is TriggerDefinitionType.PERIODIC:
            return periodic()
        if self is TriggerDefinitionType.DATA_CHANGED:
            return data_changed()
        if self is TriggerDefinitionType.DATA_ADDED:
            return data_added()
        if self is TriggerDefinitionType.DATA_MODIFIED:
            return data_modified()
        if self is TriggerDefinitionType.DATA_REMOVED:
            return data_removed()
        if self is TriggerDefinitionType.DATA_ACCESSED:
            return data_accessed()
        if self is TriggerDefinitionType.DATA_ACCESS_ENDED:
            return data_access_ended()
