# This file was auto-generated by Fern from our API Definition.

import enum
import typing

T_Result = typing.TypeVar("T_Result")


class ValueSetStatus(str, enum.Enum):
    """
    The status of this value set. Enables tracking the life-cycle of the content. The status of the value set applies to the value set definition (ValueSet.compose) and the associated ValueSet metadata. Expansions do not have a state.
    """

    DRAFT = "draft"
    ACTIVE = "active"
    RETIRED = "retired"
    UNKNOWN = "unknown"

    def visit(
        self,
        draft: typing.Callable[[], T_Result],
        active: typing.Callable[[], T_Result],
        retired: typing.Callable[[], T_Result],
        unknown: typing.Callable[[], T_Result],
    ) -> T_Result:
        if self is ValueSetStatus.DRAFT:
            return draft()
        if self is ValueSetStatus.ACTIVE:
            return active()
        if self is ValueSetStatus.RETIRED:
            return retired()
        if self is ValueSetStatus.UNKNOWN:
            return unknown()
