# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ...core.datetime_utils import serialize_datetime
from .base_resource import BaseResource
from .code import Code
from .date_time import DateTime
from .identifier import Identifier
from .reference import Reference
from .vision_prescription_lens_specification import VisionPrescriptionLensSpecification

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class VisionPrescription(BaseResource):
    """
    An authorization for the provision of glasses and/or contact lenses to a patient.
    """

    resource_type: typing.Literal["VisionPrescription"] = pydantic.Field(alias="resourceType")
    identifier: typing.Optional[typing.List[Identifier]] = pydantic.Field(
        default=None, description="A unique identifier assigned to this vision prescription."
    )
    status: typing.Optional[Code] = pydantic.Field(default=None, description="The status of the resource instance.")
    created: typing.Optional[DateTime] = pydantic.Field(default=None, description="The date this resource was created.")
    patient: Reference = pydantic.Field(
        description="A resource reference to the person to whom the vision prescription applies."
    )
    encounter: typing.Optional[Reference] = pydantic.Field(
        default=None,
        description="A reference to a resource that identifies the particular occurrence of contact between patient and health care provider during which the prescription was issued.",
    )
    date_written: typing.Optional[DateTime] = pydantic.Field(
        alias="dateWritten", default=None, description="The date (and perhaps time) when the prescription was written."
    )
    prescriber: Reference = pydantic.Field(
        description="The healthcare professional responsible for authorizing the prescription."
    )
    lens_specification: typing.List[VisionPrescriptionLensSpecification] = pydantic.Field(
        alias="lensSpecification",
        description="Contain the details of the individual lens specifications and serves as the authorization for the fullfillment by certified professionals.",
    )

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        allow_population_by_field_name = True
        json_encoders = {dt.datetime: serialize_datetime}
