# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ...core.datetime_utils import serialize_datetime
from .annotation import Annotation
from .codeable_concept import CodeableConcept
from .decimal import Decimal
from .extension import Extension
from .quantity import Quantity
from .vision_prescription_lens_specification_eye import VisionPrescriptionLensSpecificationEye
from .vision_prescription_prism import VisionPrescriptionPrism

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class VisionPrescriptionLensSpecification(pydantic.BaseModel):
    """
    An authorization for the provision of glasses and/or contact lenses to a patient.
    """

    id: typing.Optional[str] = pydantic.Field(
        default=None,
        description="Unique id for the element within a resource (for internal references). This may be any string value that does not contain spaces.",
    )
    extension: typing.Optional[typing.List[Extension]] = pydantic.Field(
        default=None,
        description="May be used to represent additional information that is not part of the basic definition of the element. To make the use of extensions safe and manageable, there is a strict set of governance applied to the definition and use of extensions. Though any implementer can define an extension, there is a set of requirements that SHALL be met as part of the definition of the extension.",
    )
    modifier_extension: typing.Optional[typing.List[Extension]] = pydantic.Field(
        alias="modifierExtension",
        default=None,
        description="May be used to represent additional information that is not part of the basic definition of the element and that modifies the understanding of the element in which it is contained and/or the understanding of the containing element's descendants. Usually modifier elements provide negation or qualification. To make the use of extensions safe and manageable, there is a strict set of governance applied to the definition and use of extensions. Though any implementer can define an extension, there is a set of requirements that SHALL be met as part of the definition of the extension. Applications processing a resource are required to check for modifier extensions. Modifier extensions SHALL NOT change the meaning of any elements on Resource or DomainResource (including cannot change the meaning of modifierExtension itself).",
    )
    product: CodeableConcept = pydantic.Field(
        description="Identifies the type of vision correction product which is required for the patient."
    )
    eye: typing.Optional[VisionPrescriptionLensSpecificationEye] = pydantic.Field(
        default=None, description="The eye for which the lens specification applies."
    )
    sphere: typing.Optional[Decimal] = pydantic.Field(
        default=None, description="Lens power measured in dioptres (0.25 units)."
    )
    cylinder: typing.Optional[Decimal] = pydantic.Field(
        default=None, description="Power adjustment for astigmatism measured in dioptres (0.25 units)."
    )
    axis: typing.Optional[int] = pydantic.Field(
        default=None, description="Adjustment for astigmatism measured in integer degrees."
    )
    prism: typing.Optional[typing.List[VisionPrescriptionPrism]] = pydantic.Field(
        default=None, description="Allows for adjustment on two axis."
    )
    add: typing.Optional[Decimal] = pydantic.Field(
        default=None, description="Power adjustment for multifocal lenses measured in dioptres (0.25 units)."
    )
    power: typing.Optional[Decimal] = pydantic.Field(
        default=None, description="Contact lens power measured in dioptres (0.25 units)."
    )
    back_curve: typing.Optional[Decimal] = pydantic.Field(
        alias="backCurve", default=None, description="Back curvature measured in millimetres."
    )
    diameter: typing.Optional[Decimal] = pydantic.Field(
        default=None, description="Contact lens diameter measured in millimetres."
    )
    duration: typing.Optional[Quantity] = pydantic.Field(
        default=None, description="The recommended maximum wear period for the lens."
    )
    color: typing.Optional[str] = pydantic.Field(default=None, description="Special color or pattern.")
    brand: typing.Optional[str] = pydantic.Field(default=None, description="Brand recommendations or restrictions.")
    note: typing.Optional[typing.List[Annotation]] = pydantic.Field(
        default=None, description="Notes for special requirements such as coatings and lens materials."
    )

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        allow_population_by_field_name = True
        json_encoders = {dt.datetime: serialize_datetime}
