# This file was auto-generated by Fern from our API Definition.

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from .document.client import AsyncDocumentClient, DocumentClient
from .facility.client import AsyncFacilityClient, FacilityClient
from .fhir.client import AsyncFhirClient, FhirClient
from .organization.client import AsyncOrganizationClient, OrganizationClient
from .patient.client import AsyncPatientClient, PatientClient


class MedicalClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper
        self.document = DocumentClient(client_wrapper=self._client_wrapper)
        self.facility = FacilityClient(client_wrapper=self._client_wrapper)
        self.fhir = FhirClient(client_wrapper=self._client_wrapper)
        self.organization = OrganizationClient(client_wrapper=self._client_wrapper)
        self.patient = PatientClient(client_wrapper=self._client_wrapper)


class AsyncMedicalClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper
        self.document = AsyncDocumentClient(client_wrapper=self._client_wrapper)
        self.facility = AsyncFacilityClient(client_wrapper=self._client_wrapper)
        self.fhir = AsyncFhirClient(client_wrapper=self._client_wrapper)
        self.organization = AsyncOrganizationClient(client_wrapper=self._client_wrapper)
        self.patient = AsyncPatientClient(client_wrapper=self._client_wrapper)
