# This file was auto-generated by Fern from our API Definition.

import typing
import urllib.parse
from json.decoder import JSONDecodeError

from ...core.api_error import ApiError
from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.jsonable_encoder import jsonable_encoder
from ...core.remove_none_from_dict import remove_none_from_dict
from ...core.request_options import RequestOptions
from ...fhir.types.document_reference import DocumentReference
from .types.bulk_get_document_url_query import BulkGetDocumentUrlQuery
from .types.conversion_type import ConversionType
from .types.document_query import DocumentQuery
from .types.document_url import DocumentUrl
from .types.list_document_references import ListDocumentReferences
from .types.upload_document_response import UploadDocumentResponse

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class DocumentClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def start_query(
        self,
        *,
        patient_id: str,
        facility_id: str,
        request: typing.Optional[typing.Dict[str, str]] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> DocumentQuery:
        """
        Triggers a document query for the specified patient across HIEs.
        When executed, this endpoint triggers an asynchronous document query across HIEs.
        This is a two step process where the documents will first be downloaded from
        the respective HIE and, if they are C-CDA/XML, then converted to FHIR.
        Each process (download, conversion) will contain its own `total` and `status`
        as well as the count for `successful` operations and `errors`.
        When the asynchronous document query finishes, it stores new/updated document
        references for future requests and updates the status of download to `completed`.
        Meanwhile, in the background, files will be converted and the convert count will be
        incremented. Once all documents have been converted it too will be marked as `completed`.
        If there's no document to be converted, the total will be set to zero and
        the status to `completed`.

        Parameters:
            - patient_id: str. The ID of the Patient for which to list available Documents.

            - facility_id: str. The ID of the Facility where the patient is receiving care.

            - request: typing.Optional[typing.Dict[str, str]].

            - request_options: typing.Optional[RequestOptions]. Request-specific configuration.
        ---
        from metriport.client import Metriport

        client = Metriport(
            api_key="YOUR_API_KEY",
        )
        client.medical.document.start_query(
            patient_id="12345678",
            facility_id="12345678",
            request={"youCan": "putAny", "stringKeyValue": "pairsHere"},
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "POST",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", "medical/v1/document/query"),
            params=jsonable_encoder(
                remove_none_from_dict(
                    {
                        "patientId": patient_id,
                        "facilityId": facility_id,
                        **(
                            request_options.get("additional_query_parameters", {})
                            if request_options is not None
                            else {}
                        ),
                    }
                )
            ),
            json=jsonable_encoder(request)
            if request_options is None or request_options.get("additional_body_parameters") is None
            else {
                **jsonable_encoder(request),
                **(jsonable_encoder(remove_none_from_dict(request_options.get("additional_body_parameters", {})))),
            },
            headers=jsonable_encoder(
                remove_none_from_dict(
                    {
                        **self._client_wrapper.get_headers(),
                        **(request_options.get("additional_headers", {}) if request_options is not None else {}),
                    }
                )
            ),
            timeout=request_options.get("timeout_in_seconds")
            if request_options is not None and request_options.get("timeout_in_seconds") is not None
            else 60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(DocumentQuery, _response.json())  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def get_query_status(
        self, *, patient_id: str, request_options: typing.Optional[RequestOptions] = None
    ) -> DocumentQuery:
        """
        Returns the document query status for the specified patient.
        Can be used in to check the progress when the final status
        of the document query is taking longer than expected.
        See more on [Start Document Query](/medical-api/api-reference/document/start-document-query).

        Parameters:
            - patient_id: str. The ID of the Patient for which to list available Documents.

            - request_options: typing.Optional[RequestOptions]. Request-specific configuration.
        ---
        from metriport.client import Metriport

        client = Metriport(
            api_key="YOUR_API_KEY",
        )
        client.medical.document.get_query_status(
            patient_id="12345678",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "POST",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", "medical/v1/document/query"),
            params=jsonable_encoder(
                remove_none_from_dict(
                    {
                        "patientId": patient_id,
                        **(
                            request_options.get("additional_query_parameters", {})
                            if request_options is not None
                            else {}
                        ),
                    }
                )
            ),
            json=jsonable_encoder(remove_none_from_dict(request_options.get("additional_body_parameters", {})))
            if request_options is not None
            else None,
            headers=jsonable_encoder(
                remove_none_from_dict(
                    {
                        **self._client_wrapper.get_headers(),
                        **(request_options.get("additional_headers", {}) if request_options is not None else {}),
                    }
                )
            ),
            timeout=request_options.get("timeout_in_seconds")
            if request_options is not None and request_options.get("timeout_in_seconds") is not None
            else 60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(DocumentQuery, _response.json())  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def list(
        self,
        *,
        patient_id: str,
        date_from: typing.Optional[str] = None,
        date_to: typing.Optional[str] = None,
        content: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ListDocumentReferences:
        """
        Lists all Documents that can be retrieved for a Patient.
        This endpoint returns the document references available
        at Metriport which are associated with the given Patient.
        To start a new document query, see the [Start Document Query endpoint](/api-reference/medical/document/start-query).

        Parameters:
            - patient_id: str. The ID of the Patient for which to list available Documents.

            - date_from: typing.Optional[str]. The start date (inclusive) for which to filter returned documents - formatted `YYYY-MM-DD` as per ISO 8601. If not provided, no start date filter will be applied.

            - date_to: typing.Optional[str]. The end date (inclusive) for which to filter returned documents - formatted `YYYY-MM-DD` as per ISO 8601. If not provided, no end date filter will be applied.

            - content: typing.Optional[str]. Value to search within the document reference and the actual contents of the document (minimum 3 chars).

            - request_options: typing.Optional[RequestOptions]. Request-specific configuration.
        """
        _response = self._client_wrapper.httpx_client.request(
            "GET",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", "medical/v1/document"),
            params=jsonable_encoder(
                remove_none_from_dict(
                    {
                        "patientId": patient_id,
                        "dateFrom": date_from,
                        "dateTo": date_to,
                        "content": content,
                        **(
                            request_options.get("additional_query_parameters", {})
                            if request_options is not None
                            else {}
                        ),
                    }
                )
            ),
            headers=jsonable_encoder(
                remove_none_from_dict(
                    {
                        **self._client_wrapper.get_headers(),
                        **(request_options.get("additional_headers", {}) if request_options is not None else {}),
                    }
                )
            ),
            timeout=request_options.get("timeout_in_seconds")
            if request_options is not None and request_options.get("timeout_in_seconds") is not None
            else 60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(ListDocumentReferences, _response.json())  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def get_url(
        self,
        *,
        file_name: str,
        conversion_type: typing.Optional[ConversionType] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> DocumentUrl:
        """
        Gets a downloadable URL for downloading the specified document.
        This endpoint returns a URL which you can use to download
        the specified document and/or convert using the file name
        provided from the [List Documents](/api-reference/medical/document/list) endpoint.

        Parameters:
            - file_name: str. The file name of the document

            - conversion_type: typing.Optional[ConversionType]. The doc type to convert to. Either `html` or `pdf`.
                                                                This parameter should only be used for converting XML/CDA files.
            - request_options: typing.Optional[RequestOptions]. Request-specific configuration.
        ---
        from metriport.client import Metriport
        from metriport.medical import ConversionType

        client = Metriport(
            api_key="YOUR_API_KEY",
        )
        client.medical.document.get_url(
            file_name="x-ray",
            conversion_type=ConversionType.PDF,
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "GET",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", "medical/v1/document/download-url"),
            params=jsonable_encoder(
                remove_none_from_dict(
                    {
                        "fileName": file_name,
                        "conversionType": conversion_type.value if conversion_type is not None else None,
                        **(
                            request_options.get("additional_query_parameters", {})
                            if request_options is not None
                            else {}
                        ),
                    }
                )
            ),
            headers=jsonable_encoder(
                remove_none_from_dict(
                    {
                        **self._client_wrapper.get_headers(),
                        **(request_options.get("additional_headers", {}) if request_options is not None else {}),
                    }
                )
            ),
            timeout=request_options.get("timeout_in_seconds")
            if request_options is not None and request_options.get("timeout_in_seconds") is not None
            else 60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(DocumentUrl, _response.json())  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def create_document_reference(
        self, *, patient_id: str, request: DocumentReference, request_options: typing.Optional[RequestOptions] = None
    ) -> UploadDocumentResponse:
        """
        Creates a DocumentReference and returns its ID and a URL to use for a medical document upload to our servers.

        Parameters:
            - patient_id: str. The ID of the Patient for which to list available Documents.

            - request: DocumentReference.

            - request_options: typing.Optional[RequestOptions]. Request-specific configuration.
        ---
        from metriport.client import Metriport
        from metriport.fhir import (
            Attachment,
            CodeableConcept,
            Coding,
            DocumentReference,
            DocumentReferenceContent,
            DocumentReferenceContext,
            Period,
        )

        client = Metriport(
            api_key="YOUR_API_KEY",
        )
        client.medical.document.create_document_reference(
            patient_id="12345678",
            request=DocumentReference(
                resource_type="DocumentReference",
                content=[
                    DocumentReferenceContent(
                        attachment=Attachment(
                            title="Burn management Hospital Progress note",
                        ),
                    )
                ],
                contained=[
                    {"resourceType": "ExampleResource", "id": "exampleId1"},
                    {"resourceType": "ExampleResource", "id": "exampleId2"},
                ],
                description="Third degree wrist burn treatment",
                type=CodeableConcept(
                    text="Burn management Hospital Progress note",
                    coding=[
                        Coding(
                            code="100556-0",
                            system="http://loinc.org",
                            display="Burn management Hospital Progress note",
                        )
                    ],
                ),
                context=DocumentReferenceContext(
                    period=Period(
                        start="2023-10-10T14:14:17Z",
                        end="2023-10-10T15:30:30Z",
                    ),
                    facility_type=CodeableConcept(
                        text="John Snow Clinic - Acute Care Centre",
                    ),
                ),
            ),
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "POST",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", "medical/v1/document/upload"),
            params=jsonable_encoder(
                remove_none_from_dict(
                    {
                        "patientId": patient_id,
                        **(
                            request_options.get("additional_query_parameters", {})
                            if request_options is not None
                            else {}
                        ),
                    }
                )
            ),
            json=jsonable_encoder(request)
            if request_options is None or request_options.get("additional_body_parameters") is None
            else {
                **jsonable_encoder(request),
                **(jsonable_encoder(remove_none_from_dict(request_options.get("additional_body_parameters", {})))),
            },
            headers=jsonable_encoder(
                remove_none_from_dict(
                    {
                        **self._client_wrapper.get_headers(),
                        **(request_options.get("additional_headers", {}) if request_options is not None else {}),
                    }
                )
            ),
            timeout=request_options.get("timeout_in_seconds")
            if request_options is not None and request_options.get("timeout_in_seconds") is not None
            else 60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(UploadDocumentResponse, _response.json())  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def start_bulk_get_document_url(
        self,
        *,
        patient_id: str,
        request: typing.Optional[typing.Dict[str, str]] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> BulkGetDocumentUrlQuery:
        """
        Triggers a process to generate a list of download URLs for all of the patient's documents.
        The status of the process is returned in the response. Initially, it will be `processing`,
        and when the process is finished, the status will be updated to `completed` or `failed`.
        If you trigger this endpoint again while the process is still running, you will get a response
        that reflects the current progress.

        Parameters:
            - patient_id: str. The ID of the patient for which to initiate the bulk URL generation.

            - request: typing.Optional[typing.Dict[str, str]].

            - request_options: typing.Optional[RequestOptions]. Request-specific configuration.
        ---
        from metriport.client import Metriport

        client = Metriport(
            api_key="YOUR_API_KEY",
        )
        client.medical.document.start_bulk_get_document_url(
            patient_id="12345678",
            request={"youCan": "putAny", "stringKeyValue": "pairsHere"},
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "POST",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", "medical/v1/document/download-url/bulk"),
            params=jsonable_encoder(
                remove_none_from_dict(
                    {
                        "patientId": patient_id,
                        **(
                            request_options.get("additional_query_parameters", {})
                            if request_options is not None
                            else {}
                        ),
                    }
                )
            ),
            json=jsonable_encoder(request)
            if request_options is None or request_options.get("additional_body_parameters") is None
            else {
                **jsonable_encoder(request),
                **(jsonable_encoder(remove_none_from_dict(request_options.get("additional_body_parameters", {})))),
            },
            headers=jsonable_encoder(
                remove_none_from_dict(
                    {
                        **self._client_wrapper.get_headers(),
                        **(request_options.get("additional_headers", {}) if request_options is not None else {}),
                    }
                )
            ),
            timeout=request_options.get("timeout_in_seconds")
            if request_options is not None and request_options.get("timeout_in_seconds") is not None
            else 60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(BulkGetDocumentUrlQuery, _response.json())  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)


class AsyncDocumentClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def start_query(
        self,
        *,
        patient_id: str,
        facility_id: str,
        request: typing.Optional[typing.Dict[str, str]] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> DocumentQuery:
        """
        Triggers a document query for the specified patient across HIEs.
        When executed, this endpoint triggers an asynchronous document query across HIEs.
        This is a two step process where the documents will first be downloaded from
        the respective HIE and, if they are C-CDA/XML, then converted to FHIR.
        Each process (download, conversion) will contain its own `total` and `status`
        as well as the count for `successful` operations and `errors`.
        When the asynchronous document query finishes, it stores new/updated document
        references for future requests and updates the status of download to `completed`.
        Meanwhile, in the background, files will be converted and the convert count will be
        incremented. Once all documents have been converted it too will be marked as `completed`.
        If there's no document to be converted, the total will be set to zero and
        the status to `completed`.

        Parameters:
            - patient_id: str. The ID of the Patient for which to list available Documents.

            - facility_id: str. The ID of the Facility where the patient is receiving care.

            - request: typing.Optional[typing.Dict[str, str]].

            - request_options: typing.Optional[RequestOptions]. Request-specific configuration.
        ---
        from metriport.client import AsyncMetriport

        client = AsyncMetriport(
            api_key="YOUR_API_KEY",
        )
        await client.medical.document.start_query(
            patient_id="12345678",
            facility_id="12345678",
            request={"youCan": "putAny", "stringKeyValue": "pairsHere"},
        )
        """
        _response = await self._client_wrapper.httpx_client.request(
            "POST",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", "medical/v1/document/query"),
            params=jsonable_encoder(
                remove_none_from_dict(
                    {
                        "patientId": patient_id,
                        "facilityId": facility_id,
                        **(
                            request_options.get("additional_query_parameters", {})
                            if request_options is not None
                            else {}
                        ),
                    }
                )
            ),
            json=jsonable_encoder(request)
            if request_options is None or request_options.get("additional_body_parameters") is None
            else {
                **jsonable_encoder(request),
                **(jsonable_encoder(remove_none_from_dict(request_options.get("additional_body_parameters", {})))),
            },
            headers=jsonable_encoder(
                remove_none_from_dict(
                    {
                        **self._client_wrapper.get_headers(),
                        **(request_options.get("additional_headers", {}) if request_options is not None else {}),
                    }
                )
            ),
            timeout=request_options.get("timeout_in_seconds")
            if request_options is not None and request_options.get("timeout_in_seconds") is not None
            else 60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(DocumentQuery, _response.json())  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def get_query_status(
        self, *, patient_id: str, request_options: typing.Optional[RequestOptions] = None
    ) -> DocumentQuery:
        """
        Returns the document query status for the specified patient.
        Can be used in to check the progress when the final status
        of the document query is taking longer than expected.
        See more on [Start Document Query](/medical-api/api-reference/document/start-document-query).

        Parameters:
            - patient_id: str. The ID of the Patient for which to list available Documents.

            - request_options: typing.Optional[RequestOptions]. Request-specific configuration.
        ---
        from metriport.client import AsyncMetriport

        client = AsyncMetriport(
            api_key="YOUR_API_KEY",
        )
        await client.medical.document.get_query_status(
            patient_id="12345678",
        )
        """
        _response = await self._client_wrapper.httpx_client.request(
            "POST",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", "medical/v1/document/query"),
            params=jsonable_encoder(
                remove_none_from_dict(
                    {
                        "patientId": patient_id,
                        **(
                            request_options.get("additional_query_parameters", {})
                            if request_options is not None
                            else {}
                        ),
                    }
                )
            ),
            json=jsonable_encoder(remove_none_from_dict(request_options.get("additional_body_parameters", {})))
            if request_options is not None
            else None,
            headers=jsonable_encoder(
                remove_none_from_dict(
                    {
                        **self._client_wrapper.get_headers(),
                        **(request_options.get("additional_headers", {}) if request_options is not None else {}),
                    }
                )
            ),
            timeout=request_options.get("timeout_in_seconds")
            if request_options is not None and request_options.get("timeout_in_seconds") is not None
            else 60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(DocumentQuery, _response.json())  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def list(
        self,
        *,
        patient_id: str,
        date_from: typing.Optional[str] = None,
        date_to: typing.Optional[str] = None,
        content: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ListDocumentReferences:
        """
        Lists all Documents that can be retrieved for a Patient.
        This endpoint returns the document references available
        at Metriport which are associated with the given Patient.
        To start a new document query, see the [Start Document Query endpoint](/api-reference/medical/document/start-query).

        Parameters:
            - patient_id: str. The ID of the Patient for which to list available Documents.

            - date_from: typing.Optional[str]. The start date (inclusive) for which to filter returned documents - formatted `YYYY-MM-DD` as per ISO 8601. If not provided, no start date filter will be applied.

            - date_to: typing.Optional[str]. The end date (inclusive) for which to filter returned documents - formatted `YYYY-MM-DD` as per ISO 8601. If not provided, no end date filter will be applied.

            - content: typing.Optional[str]. Value to search within the document reference and the actual contents of the document (minimum 3 chars).

            - request_options: typing.Optional[RequestOptions]. Request-specific configuration.
        """
        _response = await self._client_wrapper.httpx_client.request(
            "GET",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", "medical/v1/document"),
            params=jsonable_encoder(
                remove_none_from_dict(
                    {
                        "patientId": patient_id,
                        "dateFrom": date_from,
                        "dateTo": date_to,
                        "content": content,
                        **(
                            request_options.get("additional_query_parameters", {})
                            if request_options is not None
                            else {}
                        ),
                    }
                )
            ),
            headers=jsonable_encoder(
                remove_none_from_dict(
                    {
                        **self._client_wrapper.get_headers(),
                        **(request_options.get("additional_headers", {}) if request_options is not None else {}),
                    }
                )
            ),
            timeout=request_options.get("timeout_in_seconds")
            if request_options is not None and request_options.get("timeout_in_seconds") is not None
            else 60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(ListDocumentReferences, _response.json())  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def get_url(
        self,
        *,
        file_name: str,
        conversion_type: typing.Optional[ConversionType] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> DocumentUrl:
        """
        Gets a downloadable URL for downloading the specified document.
        This endpoint returns a URL which you can use to download
        the specified document and/or convert using the file name
        provided from the [List Documents](/api-reference/medical/document/list) endpoint.

        Parameters:
            - file_name: str. The file name of the document

            - conversion_type: typing.Optional[ConversionType]. The doc type to convert to. Either `html` or `pdf`.
                                                                This parameter should only be used for converting XML/CDA files.
            - request_options: typing.Optional[RequestOptions]. Request-specific configuration.
        ---
        from metriport.client import AsyncMetriport
        from metriport.medical import ConversionType

        client = AsyncMetriport(
            api_key="YOUR_API_KEY",
        )
        await client.medical.document.get_url(
            file_name="x-ray",
            conversion_type=ConversionType.PDF,
        )
        """
        _response = await self._client_wrapper.httpx_client.request(
            "GET",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", "medical/v1/document/download-url"),
            params=jsonable_encoder(
                remove_none_from_dict(
                    {
                        "fileName": file_name,
                        "conversionType": conversion_type.value if conversion_type is not None else None,
                        **(
                            request_options.get("additional_query_parameters", {})
                            if request_options is not None
                            else {}
                        ),
                    }
                )
            ),
            headers=jsonable_encoder(
                remove_none_from_dict(
                    {
                        **self._client_wrapper.get_headers(),
                        **(request_options.get("additional_headers", {}) if request_options is not None else {}),
                    }
                )
            ),
            timeout=request_options.get("timeout_in_seconds")
            if request_options is not None and request_options.get("timeout_in_seconds") is not None
            else 60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(DocumentUrl, _response.json())  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def create_document_reference(
        self, *, patient_id: str, request: DocumentReference, request_options: typing.Optional[RequestOptions] = None
    ) -> UploadDocumentResponse:
        """
        Creates a DocumentReference and returns its ID and a URL to use for a medical document upload to our servers.

        Parameters:
            - patient_id: str. The ID of the Patient for which to list available Documents.

            - request: DocumentReference.

            - request_options: typing.Optional[RequestOptions]. Request-specific configuration.
        ---
        from metriport.client import AsyncMetriport
        from metriport.fhir import (
            Attachment,
            CodeableConcept,
            Coding,
            DocumentReference,
            DocumentReferenceContent,
            DocumentReferenceContext,
            Period,
        )

        client = AsyncMetriport(
            api_key="YOUR_API_KEY",
        )
        await client.medical.document.create_document_reference(
            patient_id="12345678",
            request=DocumentReference(
                resource_type="DocumentReference",
                content=[
                    DocumentReferenceContent(
                        attachment=Attachment(
                            title="Burn management Hospital Progress note",
                        ),
                    )
                ],
                contained=[
                    {"resourceType": "ExampleResource", "id": "exampleId1"},
                    {"resourceType": "ExampleResource", "id": "exampleId2"},
                ],
                description="Third degree wrist burn treatment",
                type=CodeableConcept(
                    text="Burn management Hospital Progress note",
                    coding=[
                        Coding(
                            code="100556-0",
                            system="http://loinc.org",
                            display="Burn management Hospital Progress note",
                        )
                    ],
                ),
                context=DocumentReferenceContext(
                    period=Period(
                        start="2023-10-10T14:14:17Z",
                        end="2023-10-10T15:30:30Z",
                    ),
                    facility_type=CodeableConcept(
                        text="John Snow Clinic - Acute Care Centre",
                    ),
                ),
            ),
        )
        """
        _response = await self._client_wrapper.httpx_client.request(
            "POST",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", "medical/v1/document/upload"),
            params=jsonable_encoder(
                remove_none_from_dict(
                    {
                        "patientId": patient_id,
                        **(
                            request_options.get("additional_query_parameters", {})
                            if request_options is not None
                            else {}
                        ),
                    }
                )
            ),
            json=jsonable_encoder(request)
            if request_options is None or request_options.get("additional_body_parameters") is None
            else {
                **jsonable_encoder(request),
                **(jsonable_encoder(remove_none_from_dict(request_options.get("additional_body_parameters", {})))),
            },
            headers=jsonable_encoder(
                remove_none_from_dict(
                    {
                        **self._client_wrapper.get_headers(),
                        **(request_options.get("additional_headers", {}) if request_options is not None else {}),
                    }
                )
            ),
            timeout=request_options.get("timeout_in_seconds")
            if request_options is not None and request_options.get("timeout_in_seconds") is not None
            else 60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(UploadDocumentResponse, _response.json())  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def start_bulk_get_document_url(
        self,
        *,
        patient_id: str,
        request: typing.Optional[typing.Dict[str, str]] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> BulkGetDocumentUrlQuery:
        """
        Triggers a process to generate a list of download URLs for all of the patient's documents.
        The status of the process is returned in the response. Initially, it will be `processing`,
        and when the process is finished, the status will be updated to `completed` or `failed`.
        If you trigger this endpoint again while the process is still running, you will get a response
        that reflects the current progress.

        Parameters:
            - patient_id: str. The ID of the patient for which to initiate the bulk URL generation.

            - request: typing.Optional[typing.Dict[str, str]].

            - request_options: typing.Optional[RequestOptions]. Request-specific configuration.
        ---
        from metriport.client import AsyncMetriport

        client = AsyncMetriport(
            api_key="YOUR_API_KEY",
        )
        await client.medical.document.start_bulk_get_document_url(
            patient_id="12345678",
            request={"youCan": "putAny", "stringKeyValue": "pairsHere"},
        )
        """
        _response = await self._client_wrapper.httpx_client.request(
            "POST",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", "medical/v1/document/download-url/bulk"),
            params=jsonable_encoder(
                remove_none_from_dict(
                    {
                        "patientId": patient_id,
                        **(
                            request_options.get("additional_query_parameters", {})
                            if request_options is not None
                            else {}
                        ),
                    }
                )
            ),
            json=jsonable_encoder(request)
            if request_options is None or request_options.get("additional_body_parameters") is None
            else {
                **jsonable_encoder(request),
                **(jsonable_encoder(remove_none_from_dict(request_options.get("additional_body_parameters", {})))),
            },
            headers=jsonable_encoder(
                remove_none_from_dict(
                    {
                        **self._client_wrapper.get_headers(),
                        **(request_options.get("additional_headers", {}) if request_options is not None else {}),
                    }
                )
            ),
            timeout=request_options.get("timeout_in_seconds")
            if request_options is not None and request_options.get("timeout_in_seconds") is not None
            else 60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(BulkGetDocumentUrlQuery, _response.json())  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)
