# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ....commons.types.address import Address
from ....core.datetime_utils import serialize_datetime

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class BaseFacility(pydantic.BaseModel):
    name: str = pydantic.Field(
        description="The name of your Facility. This is the actual address where a patient will receive care (can be virtual) - for example `Care Facility, LLC`."
    )
    npi: str = pydantic.Field(
        description="The 10 digit National Provider Identifier (NPI) that will be used to make requests on behalf of the Facility."
    )
    tin: typing.Optional[str] = pydantic.Field(
        default=None, description="The Taxpayer Identification Number (TIN) of the Facility."
    )
    active: typing.Optional[bool] = pydantic.Field(
        default=None, description="Whether or not this Facility is currently active - this is usually `true`."
    )
    address: Address

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        json_encoders = {dt.datetime: serialize_datetime}
