# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ....core.datetime_utils import serialize_datetime
from .base_facility import BaseFacility

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class Facility(BaseFacility):
    """
    from metriport import Address, UsState
    from metriport.medical import Facility

    Facility(
        id="2.16.840.1.113883.3.666.123",
        name="Care Facility, LLC",
        npi="1234567891",
        address=Address(
            address_line_1="2261 Market Street",
            address_line_2="#4818",
            city="San Francisco",
            state=UsState.CA,
            zip="94114",
            country="USA",
        ),
        tin="12-3456789",
        active=True,
    )
    """

    id: str = pydantic.Field(
        description=(
            "The ID assigned to this Facility. This ID will be used\n"
            "to uniquely identify this Facility in medical documents.\n"
        )
    )

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        allow_population_by_field_name = True
        json_encoders = {dt.datetime: serialize_datetime}
